/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.utils;

import ethertaco.sundries.Sundries;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigUpdater {
    private final Sundries plugin;

    public ConfigUpdater(Sundries plugin) {
        this.plugin = plugin;
    }

    public boolean update() throws Exception {
        boolean configUpdated = this.updateConfigFile();
        boolean featuresUpdated = this.updateFeatureConfigFile();
        boolean flyUpdated = this.updateModuleConfigFile("fly");
        boolean godUpdated = this.updateModuleConfigFile("god");
        boolean autocrafterUpdated = this.updateModuleConfigFile("autocrafter");
        boolean muteUpdated = this.updateModuleConfigFile("mute");
        boolean localesUpdated = this.updateLocaleFiles();
        return configUpdated || featuresUpdated || flyUpdated || godUpdated || autocrafterUpdated || muteUpdated || localesUpdated;
    }

    private boolean updateConfigFile() throws Exception {
        this.plugin.getLogger().info("Checking for config.yml updates...");
        String pluginVersion = this.plugin.getDescription().getVersion();
        File userConfigFile = new File(this.plugin.getDataFolder(), "config.yml");
        YamlConfiguration userConfig = YamlConfiguration.loadConfiguration((File)userConfigFile);
        String configVersion = userConfig.getString("config-version", "0.0.0");
        if (!pluginVersion.equals(configVersion)) {
            this.plugin.getLogger().warning("Your config.yml version (" + configVersion + ") does not match plugin version (" + pluginVersion + "). Updating...");
            InputStream templateStream = this.plugin.getResource("config.yml");
            if (templateStream == null) {
                this.plugin.getLogger().severe("Could not find internal config.yml template. Update aborted.");
                return false;
            }
            YamlConfiguration templateConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(templateStream, StandardCharsets.UTF_8));
            for (String key : templateConfig.getKeys(true)) {
                if (userConfig.isSet(key)) continue;
                userConfig.set(key, templateConfig.get(key));
                this.plugin.getLogger().info("Adding new config key: " + key);
            }
            userConfig.set("config-version", (Object)pluginVersion);
            userConfig.save(userConfigFile);
            this.plugin.getLogger().info("config.yml has been updated to version " + pluginVersion);
            return true;
        }
        this.plugin.getLogger().info("config.yml is up to date");
        return false;
    }

    private boolean updateFeatureConfigFile() throws Exception {
        this.plugin.getLogger().info("Checking for features.yml updates...");
        File userConfigFile = new File(this.plugin.getDataFolder(), "features.yml");
        YamlConfiguration userConfig = YamlConfiguration.loadConfiguration((File)userConfigFile);
        InputStream templateStream = this.plugin.getResource("features.yml");
        if (templateStream == null) {
            this.plugin.getLogger().severe("Could not find internal features.yml template. Update aborted.");
            return false;
        }
        YamlConfiguration templateConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(templateStream, StandardCharsets.UTF_8));
        boolean updated = false;
        for (String key : templateConfig.getKeys(true)) {
            if (userConfig.isSet(key)) continue;
            userConfig.set(key, templateConfig.get(key));
            this.plugin.getLogger().info("Adding new features.yml key: " + key);
            updated = true;
        }
        if (updated) {
            userConfig.save(userConfigFile);
            this.plugin.getLogger().info("features.yml has been updated (new keys added).");
        } else {
            this.plugin.getLogger().info("features.yml is up to date (no new keys).");
        }
        return updated;
    }

    private boolean updateModuleConfigFile(String moduleName) throws Exception {
        String fileName = moduleName + ".yml";
        String filePath = "modules" + File.separator + fileName;
        this.plugin.getLogger().info(String.format("Checking for %s updates...", filePath));
        String pluginVersion = this.plugin.getDescription().getVersion();
        File userConfigFile = new File(this.plugin.getDataFolder(), filePath);
        if (!userConfigFile.exists()) {
            this.plugin.saveResource(filePath.replace(File.separator, "/"), false);
            this.plugin.getLogger().info(String.format("Created new module config file: %s.", filePath));
            return true;
        }
        YamlConfiguration userConfig = YamlConfiguration.loadConfiguration((File)userConfigFile);
        String configVersion = userConfig.getString("config-version", "0.0.0");
        if (!pluginVersion.equals(configVersion)) {
            this.plugin.getLogger().warning(String.format("Your %s version (%s) does not match plugin version (%s). Updating...", filePath, configVersion, pluginVersion));
            InputStream templateStream = this.plugin.getResource(filePath.replace(File.separator, "/"));
            if (templateStream == null) {
                this.plugin.getLogger().severe(String.format("Could not find internal %s template. Update aborted.", filePath));
                return false;
            }
            YamlConfiguration templateConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(templateStream, StandardCharsets.UTF_8));
            boolean updated = false;
            for (String key : templateConfig.getKeys(true)) {
                if (userConfig.isSet(key)) continue;
                userConfig.set(key, templateConfig.get(key));
                this.plugin.getLogger().info(String.format("Adding new key to %s: %s", filePath, key));
                updated = true;
            }
            userConfig.set("config-version", (Object)pluginVersion);
            userConfig.save(userConfigFile);
            this.plugin.getLogger().info(String.format("%s has been updated to version %s.", filePath, pluginVersion));
            return true;
        }
        this.plugin.getLogger().info(String.format("%s is up to date.", filePath));
        return false;
    }

    private boolean updateLocaleFiles() throws Exception {
        this.plugin.getLogger().info("Checking for locale file updates...");
        boolean anyLocaleUpdated = false;
        String pluginVersion = this.plugin.getDescription().getVersion();
        File localeDir = new File(this.plugin.getDataFolder(), "locale");
        if (!localeDir.exists()) {
            localeDir.mkdirs();
        }
        Set<String> internalLocales = Set.of("locale_en_US.yml", "locale_zh_CN.yml");
        for (String localeFileName : internalLocales) {
            File userLocaleFile = new File(localeDir, localeFileName);
            InputStream templateStream = this.plugin.getResource("locale/" + localeFileName);
            if (templateStream == null) {
                this.plugin.getLogger().warning("Could not find internal template for " + localeFileName);
                continue;
            }
            YamlConfiguration templateLocaleConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(templateStream, StandardCharsets.UTF_8));
            if (!userLocaleFile.exists()) {
                this.plugin.saveResource("locale/" + localeFileName, false);
                this.plugin.getLogger().info("Created new locale file: " + localeFileName);
                anyLocaleUpdated = true;
                continue;
            }
            YamlConfiguration userLocaleConfig = YamlConfiguration.loadConfiguration((File)userLocaleFile);
            String localeVersion = userLocaleConfig.getString("locale-version", "0.0.0");
            if (pluginVersion.equals(localeVersion)) continue;
            this.plugin.getLogger().warning("Your " + localeFileName + " version (" + localeVersion + ") is outdated. Updating...");
            for (String key : templateLocaleConfig.getKeys(true)) {
                if (userLocaleConfig.isSet(key)) continue;
                userLocaleConfig.set(key, templateLocaleConfig.get(key));
                if (!this.plugin.getConfigManager().getDebugMode()) continue;
                this.plugin.getLogger().fine("Adding new key '" + key + "' to " + localeFileName);
            }
            userLocaleConfig.set("locale-version", (Object)pluginVersion);
            userLocaleConfig.save(userLocaleFile);
            this.plugin.getLogger().info(localeFileName + " has been updated to version " + pluginVersion);
            anyLocaleUpdated = true;
        }
        if (!anyLocaleUpdated) {
            this.plugin.getLogger().info("All locale files are up to date");
        }
        return anyLocaleUpdated;
    }
}

