/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.sit;

import ethertaco.sundries.Sundries;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SitManager {
    private final Sundries plugin;
    private final Map<UUID, ArmorStand> seatedPlayers = new HashMap<UUID, ArmorStand>();
    private final Set<UUID> playersIgnoringMoveEvent = new HashSet<UUID>();
    public static final String SIT_METADATA_KEY = "SundriesSitSeat";

    public SitManager(Sundries plugin) {
        this.plugin = plugin;
    }

    public boolean sit(final Player player, Location armorStandSpawnLocation) {
        ArmorStand seat;
        boolean mounted;
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[SitManager] Attempting to sit player %s. Current vehicle: %s, IsSitting: %s. Target AS Location: %s", player.getName(), player.getVehicle(), this.isSitting(player), armorStandSpawnLocation));
        }
        if (player.isInsideVehicle() || this.isSitting(player)) {
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[SitManager] Player %s cannot sit, already riding/sitting.", player.getName()));
            }
            return false;
        }
        Location finalArmorStandLoc = new Location(armorStandSpawnLocation.getWorld(), (double)armorStandSpawnLocation.getBlockX() + 0.5, armorStandSpawnLocation.getY(), (double)armorStandSpawnLocation.getBlockZ() + 0.5, armorStandSpawnLocation.getYaw(), 0.0f);
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[SitManager] Spawning ArmorStand for %s at %s.", player.getName(), finalArmorStandLoc));
        }
        if (mounted = (seat = (ArmorStand)player.getWorld().spawn(finalArmorStandLoc, ArmorStand.class, as -> {
            as.setVisible(false);
            as.setGravity(false);
            as.setArms(false);
            as.setBasePlate(false);
            as.setMarker(true);
            as.setInvulnerable(true);
            as.setPersistent(false);
            as.setMetadata(SIT_METADATA_KEY, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)player.getUniqueId()));
        })).addPassenger((Entity)player)) {
            this.seatedPlayers.put(player.getUniqueId(), seat);
            this.playersIgnoringMoveEvent.add(player.getUniqueId());
            new BukkitRunnable(){

                public void run() {
                    SitManager.this.playersIgnoringMoveEvent.remove(player.getUniqueId());
                    if (SitManager.this.plugin.getConfigManager().getDebugMode()) {
                        SitManager.this.plugin.getLogger().fine(String.format("[SitManager] Player %s removed from playersIgnoringMoveEvent (task completed).", player.getName()));
                    }
                }
            }.runTaskLater((Plugin)this.plugin, 3L);
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[SitManager] Player %s successfully mounted ArmorStand. Final player location (eyes): %s.", player.getName(), player.getEyeLocation()));
            }
            return true;
        }
        seat.remove();
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().warning(String.format("[SitManager] Failed to mount player %s on ArmorStand. Removing ArmorStand.", player.getName()));
        }
        return false;
    }

    public boolean stand(final Player player) {
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[SitManager] Attempting to stand player %s. IsSitting: %s.", player.getName(), this.isSitting(player)));
        }
        if (!this.isSitting(player)) {
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[SitManager] Player %s is not sitting, cannot stand.", player.getName()));
            }
            return false;
        }
        final Location playerLoc = player.getLocation();
        final ArmorStand seat = this.seatedPlayers.remove(player.getUniqueId());
        this.playersIgnoringMoveEvent.remove(player.getUniqueId());
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[SitManager] Player %s removed from playersIgnoringMoveEvent (standing up).", player.getName()));
        }
        if (seat != null) {
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[SitManager] Player %s leaving vehicle %s.", player.getName(), seat.getUniqueId()));
            }
            player.leaveVehicle();
            new BukkitRunnable(){

                public void run() {
                    if (player.isValid() && player.isOnline()) {
                        player.teleport(seat.getLocation().add(0.0, 1.7, 0.0).setDirection(playerLoc.getDirection()));
                        if (SitManager.this.plugin.getConfigManager().getDebugMode()) {
                            SitManager.this.plugin.getLogger().fine(String.format("[SitManager] Player %s teleported to stand position at Y=%.2f.", player.getName(), player.getLocation().getY()));
                        }
                    }
                    if (seat.isValid()) {
                        seat.remove();
                        if (SitManager.this.plugin.getConfigManager().getDebugMode()) {
                            SitManager.this.plugin.getLogger().fine(String.format("[SitManager] Seat %s removed.", seat.getUniqueId()));
                        }
                    } else if (SitManager.this.plugin.getConfigManager().getDebugMode()) {
                        SitManager.this.plugin.getLogger().fine(String.format("[SitManager] Seat %s already invalid, no need to remove.", seat.getUniqueId()));
                    }
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[SitManager] Player %s successfully stood up. Initiated seat removal.", player.getName()));
            }
            return true;
        }
        return false;
    }

    public boolean isSitting(Player player) {
        return this.seatedPlayers.containsKey(player.getUniqueId());
    }

    public boolean isOurSeat(Entity entity) {
        if (!(entity instanceof ArmorStand)) {
            return false;
        }
        for (MetadataValue meta : entity.getMetadata(SIT_METADATA_KEY)) {
            if (!meta.getOwningPlugin().equals((Object)this.plugin)) continue;
            return true;
        }
        return false;
    }

    public boolean isIgnoringMoveEvent(Player player) {
        return this.playersIgnoringMoveEvent.contains(player.getUniqueId());
    }

    public void cleanupSeats() {
        this.plugin.getLogger().info("[SitManager] Cleaning up active seats...");
        this.playersIgnoringMoveEvent.clear();
        new HashMap<UUID, ArmorStand>(this.seatedPlayers).keySet().forEach(uuid -> {
            Player player = this.plugin.getServer().getPlayer(uuid);
            ArmorStand seat = this.seatedPlayers.get(uuid);
            if (seat != null && seat.isValid()) {
                if (player != null && player.isOnline() && player.getVehicle() != null && player.getVehicle().equals(seat)) {
                    player.leaveVehicle();
                    if (this.plugin.getConfigManager().getDebugMode()) {
                        this.plugin.getLogger().fine(String.format("[SitManager] Player %s forced to leave vehicle during cleanup.", player.getName()));
                    }
                }
                seat.remove();
                if (this.plugin.getConfigManager().getDebugMode()) {
                    this.plugin.getLogger().fine(String.format("[SitManager] Removed seat %s during cleanup.", seat.getUniqueId()));
                }
            } else if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[SitManager] Seat for player %s already invalid/null during cleanup, no action.", uuid));
            }
        });
        this.seatedPlayers.clear();
        for (World world : this.plugin.getServer().getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!this.isOurSeat(entity)) continue;
                entity.remove();
                if (!this.plugin.getConfigManager().getDebugMode()) continue;
                this.plugin.getLogger().fine("[SitManager] Removed lingering seat ArmorStand at " + entity.getLocation());
            }
        }
        this.plugin.getLogger().info("[SitManager] Active seats cleaned up.");
    }
}

