/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.sit;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.modules.sit.SitManager;
import ethertaco.sundries.utils.MessageUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.Stairs;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.spigotmc.event.entity.EntityDismountEvent;

public class SitListener
implements Listener {
    private final Sundries plugin;
    private final SitManager sitManager;

    public SitListener(Sundries plugin) {
        this.plugin = plugin;
        this.sitManager = plugin.getSitManager();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.plugin.getConfigManager().isPluginEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[SitListener] PlayerInteractEvent for %s, Action: %s, Block: %s, Hand: %s, Sneaking: %s", player.getName(), event.getAction(), event.hasBlock() ? event.getClickedBlock().getType() : "N/A", player.getInventory().getItemInMainHand().getType(), player.isSneaking()));
        }
        if (event.getAction().isRightClick() && event.hasBlock() && !event.isCancelled() && !player.isSneaking()) {
            Slab slab;
            Block clickedBlock = event.getClickedBlock();
            if (clickedBlock == null) {
                return;
            }
            if (!(clickedBlock.getBlockData() instanceof Stairs) && !(clickedBlock.getBlockData() instanceof Slab)) {
                if (this.plugin.getConfigManager().getDebugMode()) {
                    this.plugin.getLogger().fine(String.format("[SitListener] Block %s is not a stair or slab. Ignoring sit action.", clickedBlock.getType()));
                }
                return;
            }
            if (event.getBlockFace() != BlockFace.UP) {
                if (this.plugin.getConfigManager().getDebugMode()) {
                    this.plugin.getLogger().fine(String.format("[SitListener] Player %s clicked block %s from side/bottom (%s). Not sitting.", player.getName(), clickedBlock.getType(), event.getBlockFace()));
                }
                return;
            }
            Material handItem = player.getInventory().getItemInMainHand().getType();
            if (handItem.isBlock() && handItem.isSolid()) {
                if (this.plugin.getConfigManager().getDebugMode()) {
                    this.plugin.getLogger().fine(String.format("[SitListener] Player %s has solid block %s in hand, not attempting to sit.", player.getName(), handItem));
                }
                return;
            }
            if (handItem.isInteractable() || handItem.name().endsWith("_DOOR") || handItem.name().endsWith("_BUTTON") || handItem.name().endsWith("_LEVER") || handItem.name().endsWith("_BED") || handItem.name().contains("BUCKET") || handItem.name().equals("FLINT_AND_STEEL") || handItem.name().equals("COMPASS") || handItem.name().equals("CLOCK") || handItem.name().contains("_MAP") || handItem.name().contains("RECORD_")) {
                if (this.plugin.getConfigManager().getDebugMode()) {
                    this.plugin.getLogger().fine(String.format("[SitListener] Player %s has interactable item %s in hand, not attempting to sit.", player.getName(), handItem));
                }
                return;
            }
            if (!player.hasPermission("sundries.feature.sitonstairs")) {
                if (this.plugin.getConfigManager().getDebugMode()) {
                    this.plugin.getLogger().fine(String.format("[SitListener] Player %s tried to sit on stairs/slab but lacks permission 'sundries.feature.sitonstairs'.", player.getName()));
                }
                return;
            }
            if (!this.plugin.getFeatureToggleManager().isFeatureEnabled(player, "sit")) {
                if (this.plugin.getConfigManager().getDebugMode()) {
                    this.plugin.getLogger().fine(String.format("[SitListener] Player %s tried to sit, but 'sit' feature is disabled for them.", player.getName()));
                }
                MessageUtils.sendError((CommandSender)player, "command.sit.feature_disabled", new Object[0]);
                return;
            }
            if (this.sitManager.isSitting(player)) {
                if (this.sitManager.stand(player)) {
                    event.setCancelled(true);
                    MessageUtils.sendInfo((CommandSender)player, "command.sit.stand_up_success", new Object[0]);
                }
                return;
            }
            Block blockAbovePlayer = clickedBlock.getRelative(BlockFace.UP);
            Block blockTwoAbovePlayer = blockAbovePlayer.getRelative(BlockFace.UP);
            if (blockAbovePlayer.getType().isSolid() || blockTwoAbovePlayer.getType().isSolid()) {
                if (this.plugin.getConfigManager().getDebugMode()) {
                    this.plugin.getLogger().fine(String.format("[SitListener] Player %s cannot sit, solid block above at %s. Block 1: %s, Block 2: %s", player.getName(), clickedBlock.getLocation(), blockAbovePlayer.getType(), blockTwoAbovePlayer.getType()));
                }
                MessageUtils.sendError((CommandSender)player, "command.sit.no_space_above", new Object[0]);
                return;
            }
            Location armorStandSpawnLocation = null;
            if (clickedBlock.getBlockData() instanceof Stairs) {
                Stairs stairs = (Stairs)clickedBlock.getBlockData();
                if (stairs.getHalf() == Bisected.Half.BOTTOM) {
                    armorStandSpawnLocation = clickedBlock.getLocation().add(0.5, 0.3, 0.5);
                    if (stairs instanceof Directional) {
                        Stairs directional = stairs;
                        BlockFace facing = directional.getFacing();
                        float yaw = player.getLocation().getYaw();
                        switch (facing) {
                            case NORTH: {
                                yaw = 0.0f;
                                break;
                            }
                            case EAST: {
                                yaw = 90.0f;
                                break;
                            }
                            case SOUTH: {
                                yaw = 180.0f;
                                break;
                            }
                            case WEST: {
                                yaw = 270.0f;
                                break;
                            }
                        }
                        armorStandSpawnLocation.setYaw(yaw);
                    } else {
                        armorStandSpawnLocation.setYaw(player.getLocation().getYaw());
                    }
                }
            } else if (clickedBlock.getBlockData() instanceof Slab && (slab = (Slab)clickedBlock.getBlockData()).getType() == Slab.Type.BOTTOM) {
                armorStandSpawnLocation = clickedBlock.getLocation().add(0.5, 0.3, 0.5);
                armorStandSpawnLocation.setYaw(player.getLocation().getYaw());
            }
            if (armorStandSpawnLocation != null && clickedBlock.getType() != Material.AIR) {
                if (this.sitManager.sit(player, armorStandSpawnLocation)) {
                    event.setCancelled(true);
                    MessageUtils.sendSuccess((CommandSender)player, "command.sit.sit_down_success", new Object[0]);
                } else if (this.plugin.getConfigManager().getDebugMode()) {
                    this.plugin.getLogger().fine(String.format("[SitListener] Player %s tried to sit at %s, but sitManager.sit returned false.", player.getName(), armorStandSpawnLocation));
                }
            }
        }
    }

    @EventHandler
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        if (!this.plugin.getConfigManager().isPluginEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (event.isSneaking() && this.sitManager.isSitting(player) && this.sitManager.stand(player)) {
            MessageUtils.sendInfo((CommandSender)player, "command.sit.stand_up_success", new Object[0]);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!this.plugin.getConfigManager().isPluginEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.sitManager.isIgnoringMoveEvent(player)) {
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[SitListener] Player %s is ignoring move event. Not checking for stand-up.", player.getName()));
            }
            return;
        }
        if (this.sitManager.isSitting(player)) {
            Location from = event.getFrom();
            Location to = event.getTo();
            if (to == null) {
                return;
            }
            if (from.distanceSquared(to) > 0.15 && this.sitManager.stand(player)) {
                MessageUtils.sendInfo((CommandSender)player, "command.sit.stand_up_moved", new Object[0]);
            }
        }
    }

    @EventHandler
    public void onEntityDismount(EntityDismountEvent event) {
        if (!this.plugin.getConfigManager().isPluginEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (this.sitManager.isOurSeat(event.getDismounted())) {
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[SitListener] Player %s dismounted our seat at %s. Triggering stand().", player.getName(), event.getDismounted().getLocation()));
            }
            this.sitManager.stand(player);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (!this.plugin.getConfigManager().isPluginEnabled()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (this.sitManager.isSitting(player) && this.sitManager.stand(player)) {
            MessageUtils.sendInfo((CommandSender)player, "command.sit.stand_up_damaged", new Object[0]);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (!this.plugin.getConfigManager().isPluginEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.sitManager.isSitting(player)) {
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[SitListener] Player %s quit while sitting. Triggering stand().", player.getName()));
            }
            this.sitManager.stand(player);
        }
    }
}

