/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.sit;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.commands.AbstractCommand;
import ethertaco.sundries.modules.sit.SitManager;
import ethertaco.sundries.utils.MessageUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SitCommand
extends AbstractCommand {
    private final SitManager sitManager;

    public SitCommand(Sundries plugin) {
        super(plugin, "sit", "sundries.command.sit.self");
        this.sitManager = plugin.getSitManager();
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        String senderName;
        String string = senderName = sender instanceof Player ? sender.getName() : "Console";
        if (args.length == 0) {
            if (!this.isPlayer(sender)) {
                return true;
            }
            Player targetPlayer = (Player)sender;
            if (!this.checkPermission(sender)) {
                return true;
            }
            if (!this.plugin.getFeatureToggleManager().isFeatureEnabled(targetPlayer, "sit")) {
                MessageUtils.sendError((CommandSender)targetPlayer, "command.sit.feature_disabled", new Object[0]);
                return true;
            }
            if (this.sitManager.isSitting(targetPlayer)) {
                if (this.sitManager.stand(targetPlayer)) {
                    MessageUtils.sendSuccess(sender, "command.sit.stand_up_success", new Object[0]);
                } else {
                    MessageUtils.sendError(sender, "command.sit.stand_up_failed", new Object[0]);
                }
            } else {
                Location playerFeetLocation = targetPlayer.getLocation();
                Block blockAbovePlayer = playerFeetLocation.getBlock().getRelative(BlockFace.UP);
                Block blockTwoAbovePlayer = blockAbovePlayer.getRelative(BlockFace.UP);
                if (blockAbovePlayer.getType().isSolid() || blockTwoAbovePlayer.getType().isSolid()) {
                    if (this.plugin.getConfigManager().getDebugMode()) {
                        this.plugin.getLogger().fine(String.format("[SitCommand] Player %s cannot sit, solid block above at %s. Block 1: %s, Block 2: %s", targetPlayer.getName(), playerFeetLocation, blockAbovePlayer.getType(), blockTwoAbovePlayer.getType()));
                    }
                    MessageUtils.sendError((CommandSender)targetPlayer, "command.sit.no_space_above", new Object[0]);
                    return false;
                }
                Location armorStandSpawnLocation = new Location(playerFeetLocation.getWorld(), (double)playerFeetLocation.getBlockX() + 0.5, playerFeetLocation.getY() - 0.2, (double)playerFeetLocation.getBlockZ() + 0.5, playerFeetLocation.getYaw(), 0.0f);
                if (this.sitManager.sit(targetPlayer, armorStandSpawnLocation)) {
                    MessageUtils.sendSuccess(sender, "command.sit.sit_down_success", new Object[0]);
                } else {
                    MessageUtils.sendError(sender, "command.sit.sit_down_failed", new Object[0]);
                }
            }
            return true;
        }
        if (args.length == 1) {
            if (!sender.hasPermission("sundries.command.sit.others")) {
                MessageUtils.sendError(sender, "command.no_permission", "permission", "sundries.command.sit.others");
                return true;
            }
            Player targetPlayer = Bukkit.getPlayer((String)args[0]);
            if (targetPlayer == null) {
                MessageUtils.sendError(sender, "command.not_online", "player_name", args[0]);
                return false;
            }
            if (!this.plugin.getFeatureToggleManager().isFeatureEnabled(targetPlayer, "sit")) {
                MessageUtils.sendError(sender, "command.sit.feature_disabled_for_player", "player_name", targetPlayer.getName());
                return true;
            }
            if (this.sitManager.isSitting(targetPlayer)) {
                if (this.sitManager.stand(targetPlayer)) {
                    MessageUtils.sendSuccess(sender, "command.sit.stand_up_other_success", "player_name", targetPlayer.getName());
                    MessageUtils.sendMessage((Audience)targetPlayer, "command.sit.stand_up_by_other", "sender_name", senderName);
                } else {
                    MessageUtils.sendError(sender, "command.sit.stand_up_other_failed", "player_name", targetPlayer.getName());
                }
            } else {
                Location playerFeetLocation = targetPlayer.getLocation();
                Block blockAbovePlayer = playerFeetLocation.getBlock().getRelative(BlockFace.UP);
                Block blockTwoAbovePlayer = blockAbovePlayer.getRelative(BlockFace.UP);
                if (blockAbovePlayer.getType().isSolid() || blockTwoAbovePlayer.getType().isSolid()) {
                    MessageUtils.sendError(sender, "command.sit.no_space_above", new Object[0]);
                    return false;
                }
                Location armorStandSpawnLocation = new Location(playerFeetLocation.getWorld(), (double)playerFeetLocation.getBlockX() + 0.5, playerFeetLocation.getY() - 0.2, (double)playerFeetLocation.getBlockZ() + 0.5, playerFeetLocation.getYaw(), 0.0f);
                if (this.sitManager.sit(targetPlayer, armorStandSpawnLocation)) {
                    MessageUtils.sendSuccess(sender, "command.sit.sit_down_other_success", "player_name", targetPlayer.getName());
                    MessageUtils.sendMessage((Audience)targetPlayer, "command.sit.sit_down_by_other", "sender_name", senderName);
                } else {
                    MessageUtils.sendError(sender, "command.sit.sit_down_other_failed", "player_name", targetPlayer.getName());
                }
            }
            return true;
        }
        this.sendUsage(sender, "/su sit [player_name]");
        return false;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (args.length == 1 && sender.hasPermission("sundries.command.sit.others")) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

