/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.simplecommand;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.commands.AbstractCommand;
import ethertaco.sundries.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SudoCommand
extends AbstractCommand {
    public SudoCommand(Sundries plugin) {
        super(plugin, "sudo", "sundries.admin.sudo");
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!this.checkPermission(sender)) {
            return true;
        }
        if (sender instanceof Player) {
            Player playerSender = (Player)sender;
            if (!this.plugin.getFeatureToggleManager().isFeatureEnabled(playerSender, "sudo")) {
                MessageUtils.sendError((CommandSender)playerSender, "command.sudo.feature_disabled", new Object[0]);
                return true;
            }
        }
        if (args.length < 2) {
            this.sendUsage(sender, "/su sudo <player_name> <command|c:<message>>");
            return false;
        }
        String targetPlayerName = args[0];
        Player targetPlayer = Bukkit.getPlayer((String)targetPlayerName);
        if (targetPlayer == null) {
            MessageUtils.sendError(sender, "command.not_online", "player_name", targetPlayerName);
            return false;
        }
        if (this.plugin.getFeatureToggleManager().isFeatureEnabled(targetPlayer, "sudo_bypass")) {
            MessageUtils.sendError(sender, "command.sudo.target_bypassed", "player_name", targetPlayer.getName());
            return false;
        }
        StringBuilder actionBuilder = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            actionBuilder.append(args[i]).append(" ");
        }
        String actionString = actionBuilder.toString().trim();
        if (actionString.startsWith("c:")) {
            String message = actionString.substring(2).trim();
            targetPlayer.chat(message);
            MessageUtils.sendSuccess(sender, "command.sudo.chat_executed", "player_name", targetPlayerName, "message", message);
        } else {
            String command = actionString;
            targetPlayer.performCommand(command);
            MessageUtils.sendSuccess(sender, "command.sudo.command_executed", "player_name", targetPlayerName, "command", command);
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (!sender.hasPermission(this.permission)) {
            return Collections.emptyList();
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList()));
        } else if (args.length == 2 && "c:".startsWith(args[1].toLowerCase())) {
            completions.add("c:");
        }
        return completions;
    }
}

