/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.simplecommand;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.commands.AbstractCommand;
import ethertaco.sundries.utils.MessageUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GameModeCommand
extends AbstractCommand {
    public GameModeCommand(Sundries plugin) {
        super(plugin, "gm", "sundries.command.gamemode.self");
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        Player targetPlayer;
        if (args.length == 0) {
            this.sendUsage(sender, "/gm <mode> [player]");
            return false;
        }
        GameMode targetGameMode = this.parseGameMode(args[0]);
        if (targetGameMode == null) {
            MessageUtils.sendError(sender, "command.gamemode.invalid_mode", "mode", args[0]);
            return false;
        }
        boolean isSelf = true;
        if (args.length == 1) {
            if (!this.isPlayer(sender)) {
                this.sendUsage(sender, "/gm <mode> [player]");
                return true;
            }
            targetPlayer = (Player)sender;
        } else {
            targetPlayer = Bukkit.getPlayer((String)args[1]);
            if (targetPlayer == null) {
                MessageUtils.sendError(sender, "command.not_online", "player_name", args[1]);
                return false;
            }
            isSelf = sender.getName().equals(targetPlayer.getName());
        }
        boolean useVanilla = this.plugin.getConfigManager().useVanillaGamemodePermissions();
        String basePerm = isSelf ? "sundries.command.gamemode.self" : "sundries.command.gamemode.others";
        String modePerm = "sundries.command.gamemode." + targetGameMode.name().toLowerCase();
        if (useVanilla) {
            if (!sender.hasPermission("minecraft.command.gamemode")) {
                MessageUtils.sendError(sender, "command.no_permission", "permission", "minecraft.command.gamemode");
                return true;
            }
        } else {
            if (!sender.hasPermission(basePerm)) {
                MessageUtils.sendError(sender, "command.no_permission", "permission", basePerm);
                return true;
            }
            if (!sender.hasPermission(modePerm)) {
                MessageUtils.sendError(sender, "command.no_permission", "permission", modePerm);
                return true;
            }
        }
        targetPlayer.setGameMode(targetGameMode);
        String gamemodeName = this.plugin.getLangManager().getMessage("gamemode." + targetGameMode.name().toLowerCase());
        if (isSelf) {
            MessageUtils.sendSuccess(sender, "command.gamemode.set_self", "gamemode", gamemodeName);
        } else {
            MessageUtils.sendSuccess(sender, "command.gamemode.set_other", "player_name", targetPlayer.getName(), "gamemode", gamemodeName);
            MessageUtils.sendMessage((Audience)targetPlayer, "command.gamemode.set_by_other", "sender_name", sender.getName(), "gamemode", gamemodeName);
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("0", "1", "2", "3", "survival", "creative", "adventure", "spectator").stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && sender.hasPermission("sundries.command.gamemode.others")) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private GameMode parseGameMode(String arg) {
        switch (arg.toLowerCase()) {
            case "0": 
            case "s": 
            case "survival": {
                return GameMode.SURVIVAL;
            }
            case "1": 
            case "c": 
            case "creative": {
                return GameMode.CREATIVE;
            }
            case "2": 
            case "a": 
            case "adventure": {
                return GameMode.ADVENTURE;
            }
            case "3": 
            case "sp": 
            case "spectator": {
                return GameMode.SPECTATOR;
            }
        }
        return null;
    }
}

