/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.mute;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.commands.AbstractCommand;
import ethertaco.sundries.modules.mute.MuteManager;
import ethertaco.sundries.modules.mute.MuteType;
import ethertaco.sundries.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UnmuteCommand
extends AbstractCommand {
    private final MuteManager muteManager;

    public UnmuteCommand(Sundries plugin) {
        super(plugin, "unmute", "sundries.command.unmute.others");
        this.muteManager = plugin.getMuteManager();
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        String requiredPermission;
        boolean isSelfUnmute;
        if (!this.plugin.getConfigManager().isPluginEnabled() || !this.plugin.getFeatureToggleManager().getDefaultGlobalFeatureStatus("mute")) {
            MessageUtils.sendError(sender, "command.mute.feature_disabled", new Object[0]);
            return true;
        }
        if (args.length == 0) {
            this.sendUsage(sender, "/unmute <player> [chat|command|all]");
            return true;
        }
        String targetPlayerName = args[0];
        Player targetPlayer = Bukkit.getPlayer((String)targetPlayerName);
        if (targetPlayer == null) {
            MessageUtils.sendError(sender, "command.not_online", "player_name", targetPlayerName);
            return true;
        }
        MuteType unmuteType = MuteType.ALL;
        if (args.length >= 2) {
            try {
                unmuteType = MuteType.valueOf(args[1].toUpperCase());
            }
            catch (IllegalArgumentException e) {
                MessageUtils.sendError(sender, "command.mute.invalid_type", "type_arg", args[1]);
                return true;
            }
        }
        boolean bl = isSelfUnmute = sender instanceof Player && sender.getName().equalsIgnoreCase(targetPlayer.getName());
        if (unmuteType == MuteType.ALL) {
            requiredPermission = isSelfUnmute ? "sundries.command.unmute.self" : "sundries.command.unmute.others";
        } else {
            String string = requiredPermission = isSelfUnmute ? "sundries.command.unmute.self" : "sundries.command.unmute.others";
        }
        if (!sender.hasPermission(requiredPermission)) {
            MessageUtils.sendError(sender, "command.no_permission", "permission", requiredPermission);
            return true;
        }
        this.muteManager.unmutePlayer(targetPlayer, unmuteType, sender, true);
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (!sender.hasPermission("sundries.command.unmute.others")) {
            return Collections.emptyList();
        }
        ArrayList completions = new ArrayList();
        String currentArg = args[args.length - 1].toLowerCase();
        if (args.length == 1) {
            completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList()));
            String storageMode = this.plugin.getConfigManager().getStorageMode("mute");
            this.plugin.getMuteConfig().getAllMutedPlayerKeys().stream().map(key -> {
                if ("uuid".equals(storageMode)) {
                    try {
                        return Bukkit.getOfflinePlayer((UUID)UUID.fromString(key)).getName();
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                return key;
            }).filter(name -> name != null).forEach(completions::add);
            return completions.stream().distinct().filter(name -> name.toLowerCase().startsWith(currentArg)).collect(Collectors.toList());
        }
        if (args.length == 2) {
            return Arrays.asList("chat", "command", "all").stream().filter(s -> s.toLowerCase().startsWith(currentArg)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

