/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.mute;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.modules.mute.MuteConfig;
import ethertaco.sundries.modules.mute.MuteDetail;
import ethertaco.sundries.modules.mute.MuteEntry;
import ethertaco.sundries.modules.mute.MuteType;
import ethertaco.sundries.utils.MessageUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class MuteManager {
    private final Sundries plugin;
    private final MuteConfig muteConfig;
    private BukkitTask muteCheckTask;
    private final Map<UUID, MuteEntry> onlinePlayerMutes = new HashMap<UUID, MuteEntry>();

    public MuteManager(Sundries plugin, MuteConfig muteConfig) {
        this.plugin = plugin;
        this.muteConfig = muteConfig;
        this.startMuteCheckTask();
    }

    private void startMuteCheckTask() {
        if (this.muteCheckTask != null) {
            this.muteCheckTask.cancel();
        }
        this.muteCheckTask = new BukkitRunnable(){

            public void run() {
                if (!MuteManager.this.plugin.getConfigManager().isPluginEnabled() || !MuteManager.this.plugin.getFeatureToggleManager().getDefaultGlobalFeatureStatus("mute")) {
                    return;
                }
                new HashSet<UUID>(MuteManager.this.onlinePlayerMutes.keySet()).forEach(uuid -> {
                    Player player = Bukkit.getPlayer((UUID)uuid);
                    if (player != null && player.isOnline()) {
                        MuteEntry entry = MuteManager.this.onlinePlayerMutes.get(uuid);
                        if (entry != null) {
                            entry.cleanupExpiredMutes();
                            if (entry.isEmpty()) {
                                MuteManager.this.onlinePlayerMutes.remove(uuid);
                            }
                        }
                    } else {
                        MuteManager.this.onlinePlayerMutes.remove(uuid);
                    }
                });
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 400L, 400L);
    }

    public boolean mutePlayer(Player target, MuteType type, long durationMillis, String reason, CommandSender muter, boolean sendMessage) {
        if (!this.plugin.getFeatureToggleManager().isFeatureEnabled(target, "mute")) {
            if (sendMessage) {
                MessageUtils.sendError(muter, "command.mute.feature_disabled_for_player", "player_name", target.getName());
            }
            return false;
        }
        String targetKey = this.plugin.getConfigManager().getPlayerStorageKey(target, "mute");
        MuteEntry entry = this.muteConfig.getMuteEntry(targetKey);
        if (entry == null) {
            entry = new MuteEntry(targetKey);
        }
        List<MuteType> muteTypesToApply = type == MuteType.ALL ? Arrays.asList(MuteType.CHAT, MuteType.COMMAND) : Collections.singletonList(type);
        boolean anyMuted = false;
        for (MuteType muteType : muteTypesToApply) {
            if (entry.isMuted(muteType)) continue;
            UUID muterId = muter instanceof Player ? ((Player)muter).getUniqueId() : new UUID(0L, 0L);
            MuteDetail detail = new MuteDetail(reason, muterId, durationMillis);
            entry.addMute(muteType, detail);
            anyMuted = true;
        }
        if (!anyMuted) {
            if (sendMessage) {
                MessageUtils.sendInfo(muter, "command.mute.player_already_muted", "player_name", target.getName(), "mute_type", type.name().toLowerCase());
            }
            return false;
        }
        this.muteConfig.saveMuteEntry(entry);
        this.onlinePlayerMutes.put(target.getUniqueId(), entry);
        if (sendMessage) {
            String durationInfo = durationMillis == 0L ? this.plugin.getLangManager().getMessage("duration.permanent") : new MuteDetail("", null, durationMillis).getFormattedRemainingTime();
            String durationPlaceholder = this.plugin.getLangManager().getMessage("duration.remaining", "remaining_time", durationInfo);
            if (muter == target) {
                MessageUtils.sendSuccess(muter, "command.mute.muted_self", "mute_type", type.name().toLowerCase(), "reason", reason, "duration_info", durationPlaceholder);
            } else {
                MessageUtils.sendSuccess(muter, "command.mute.muted_other", "player_name", target.getName(), "mute_type", type.name().toLowerCase(), "reason", reason, "duration_info", durationPlaceholder);
                MessageUtils.sendMessage((Audience)target, "command.mute.muted_by_other", "sender_name", muter.getName(), "mute_type", type.name().toLowerCase(), "reason", reason, "duration_info", durationPlaceholder);
            }
        }
        this.broadcastMuteStatus(target, type, muter, reason, durationMillis, true);
        return true;
    }

    public boolean unmutePlayer(Player target, MuteType type, CommandSender unmuter, boolean sendMessage) {
        String targetKey = this.plugin.getConfigManager().getPlayerStorageKey(target, "mute");
        MuteEntry entry = this.muteConfig.getMuteEntry(targetKey);
        if (entry == null || entry.isEmpty()) {
            if (sendMessage) {
                MessageUtils.sendInfo(unmuter, "command.mute.player_not_muted", "player_name", target.getName());
            }
            return false;
        }
        List<MuteType> muteTypesToUnapply = type == MuteType.ALL ? Arrays.asList(MuteType.CHAT, MuteType.COMMAND) : Collections.singletonList(type);
        boolean anyUnmuted = false;
        for (MuteType muteType : muteTypesToUnapply) {
            if (!entry.isMuted(muteType)) continue;
            entry.removeMute(muteType);
            anyUnmuted = true;
        }
        if (!anyUnmuted) {
            if (sendMessage) {
                MessageUtils.sendInfo(unmuter, "command.mute.player_not_muted_for_type", "player_name", target.getName(), "mute_type", type.name().toLowerCase());
            }
            return false;
        }
        if (entry.isEmpty()) {
            this.muteConfig.removeMuteEntry(targetKey);
            this.onlinePlayerMutes.remove(target.getUniqueId());
        } else {
            this.muteConfig.saveMuteEntry(entry);
            this.onlinePlayerMutes.put(target.getUniqueId(), entry);
        }
        if (sendMessage) {
            if (unmuter == target) {
                MessageUtils.sendSuccess(unmuter, "command.mute.unmuted_self", "mute_type", type.name().toLowerCase());
            } else {
                MessageUtils.sendSuccess(unmuter, "command.mute.unmuted_other", "player_name", target.getName(), "mute_type", type.name().toLowerCase());
                MessageUtils.sendMessage((Audience)target, "command.mute.unmuted_by_other", "sender_name", unmuter.getName(), "mute_type", type.name().toLowerCase());
            }
        }
        this.broadcastMuteStatus(target, type, unmuter, "", 0L, false);
        return true;
    }

    public boolean isMuted(Player player, MuteType type) {
        if (this.plugin.getFeatureToggleManager().isFeatureEnabled(player, "mute.bypass")) {
            return false;
        }
        MuteEntry entry = this.onlinePlayerMutes.get(player.getUniqueId());
        return entry != null && entry.isMuted(type);
    }

    public MuteEntry getMuteStatus(Player player) {
        return this.onlinePlayerMutes.get(player.getUniqueId());
    }

    private void broadcastMuteStatus(Player target, MuteType type, CommandSender sender, String reason, long durationMillis, boolean isMute) {
        String senderName;
        if (isMute && !this.muteConfig.isBroadcastOnMute() || !isMute && !this.muteConfig.isBroadcastOnUnmute()) {
            return;
        }
        String string = senderName = sender instanceof Player ? sender.getName() : "Console";
        if (isMute) {
            String durationInfo = durationMillis == 0L ? this.plugin.getLangManager().getMessage("duration.permanent") : new MuteDetail("", null, durationMillis).getFormattedRemainingTime();
            String durationPlaceholder = this.plugin.getLangManager().getMessage("duration.remaining", "remaining_time", durationInfo);
            String messageKey = switch (type) {
                case MuteType.CHAT -> "mute.broadcast_muted_chat";
                case MuteType.COMMAND -> "mute.broadcast_muted_command";
                default -> "mute.broadcast_muted_all";
            };
            for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
                MessageUtils.sendMessage((Audience)onlinePlayer, messageKey, "player_name", target.getName(), "sender_name", senderName, "reason", reason, "duration_info", durationPlaceholder);
            }
        } else {
            String messageKey = switch (type) {
                case MuteType.CHAT -> "mute.broadcast_unmuted_chat";
                case MuteType.COMMAND -> "mute.broadcast_unmuted_command";
                default -> "mute.broadcast_unmuted_all";
            };
            for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
                MessageUtils.sendMessage((Audience)onlinePlayer, messageKey, "player_name", target.getName(), "sender_name", senderName);
            }
        }
    }

    public void loadPlayerMutes(Player player) {
        String playerKey = this.plugin.getConfigManager().getPlayerStorageKey(player, "mute");
        MuteEntry entry = this.muteConfig.getMuteEntry(playerKey);
        if (entry != null && entry.isMutedAny()) {
            this.onlinePlayerMutes.put(player.getUniqueId(), entry);
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[MuteManager] Player %s has active mutes on join.", player.getName()));
            }
        } else {
            this.onlinePlayerMutes.remove(player.getUniqueId());
        }
    }

    public void unloadPlayerMutes(Player player) {
        this.onlinePlayerMutes.remove(player.getUniqueId());
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[MuteManager] Player %s's mute state unloaded from memory.", player.getName()));
        }
    }

    public void cleanup() {
        if (this.muteCheckTask != null) {
            this.muteCheckTask.cancel();
        }
        this.onlinePlayerMutes.clear();
        this.muteConfig.saveConfig();
        this.plugin.getLogger().info("[MuteManager] Mute states cleaned up.");
    }
}

