/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.mute;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.modules.mute.MuteDetail;
import ethertaco.sundries.modules.mute.MuteEntry;
import ethertaco.sundries.modules.mute.MuteManager;
import ethertaco.sundries.modules.mute.MuteType;
import ethertaco.sundries.utils.MessageUtils;
import net.kyori.adventure.audience.Audience;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class MuteListener
implements Listener {
    private final Sundries plugin;
    private final MuteManager muteManager;

    public MuteListener(Sundries plugin) {
        this.plugin = plugin;
        this.muteManager = plugin.getMuteManager();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onAsyncPlayerChat(AsyncPlayerChatEvent event) {
        if (!this.plugin.getConfigManager().isPluginEnabled() || !this.plugin.getFeatureToggleManager().isFeatureEnabled(event.getPlayer(), "mute")) {
            return;
        }
        if (this.muteManager.isMuted(event.getPlayer(), MuteType.CHAT)) {
            event.setCancelled(true);
            MuteEntry entry = this.muteManager.getMuteStatus(event.getPlayer());
            if (entry != null) {
                MuteDetail detail = entry.getMuteDetail(MuteType.CHAT);
                if (detail != null) {
                    MessageUtils.sendMessage((Audience)event.getPlayer(), "mute.chat_message", "reason", detail.getReason(), "duration_info", detail.getFormattedRemainingTime());
                } else {
                    MessageUtils.sendMessage((Audience)event.getPlayer(), "mute.chat_message", "reason", Sundries.getInstance().getLangManager().getMessage("mute.default_reason"), "duration_info", Sundries.getInstance().getLangManager().getMessage("duration.permanent"));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String subCommand;
        String[] args;
        if (!this.plugin.getConfigManager().isPluginEnabled() || !this.plugin.getFeatureToggleManager().isFeatureEnabled(event.getPlayer(), "mute")) {
            return;
        }
        String command = event.getMessage().split(" ")[0].toLowerCase();
        if ((command.equals("/su") || command.equals("/sundries") || command.equals("/sun") || command.equals("/sd")) && (args = event.getMessage().split(" ")).length > 1 && ((subCommand = args[1].toLowerCase()).equals("mute") || subCommand.equals("unmute") || subCommand.equals("checkmute") || subCommand.equals("help"))) {
            return;
        }
        if (command.equals("/mute") || command.equals("/unmute") || command.equals("/checkmute")) {
            return;
        }
        if (this.muteManager.isMuted(event.getPlayer(), MuteType.COMMAND)) {
            event.setCancelled(true);
            MuteEntry entry = this.muteManager.getMuteStatus(event.getPlayer());
            if (entry != null) {
                MuteDetail detail = entry.getMuteDetail(MuteType.COMMAND);
                if (detail != null) {
                    MessageUtils.sendMessage((Audience)event.getPlayer(), "mute.command_message", "reason", detail.getReason(), "duration_info", detail.getFormattedRemainingTime());
                } else {
                    MessageUtils.sendMessage((Audience)event.getPlayer(), "mute.command_message", "reason", Sundries.getInstance().getLangManager().getMessage("mute.default_reason"), "duration_info", Sundries.getInstance().getLangManager().getMessage("duration.permanent"));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.plugin.getConfigManager().isPluginEnabled() || !this.plugin.getFeatureToggleManager().isFeatureEnabled(event.getPlayer(), "mute")) {
            return;
        }
        this.muteManager.loadPlayerMutes(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (!this.plugin.getConfigManager().isPluginEnabled() || !this.plugin.getFeatureToggleManager().isFeatureEnabled(event.getPlayer(), "mute")) {
            return;
        }
        this.muteManager.unloadPlayerMutes(event.getPlayer());
    }
}

