/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.mute;

import ethertaco.sundries.modules.mute.MuteDetail;
import ethertaco.sundries.modules.mute.MuteType;
import java.util.EnumMap;
import java.util.Map;

public class MuteEntry {
    private String playerKey;
    private Map<MuteType, MuteDetail> activeMutes;

    public MuteEntry(String playerKey) {
        this.playerKey = playerKey;
        this.activeMutes = new EnumMap<MuteType, MuteDetail>(MuteType.class);
    }

    public MuteEntry(String playerKey, Map<MuteType, MuteDetail> activeMutes) {
        this.playerKey = playerKey;
        this.activeMutes = activeMutes != null ? new EnumMap<MuteType, MuteDetail>(activeMutes) : new EnumMap(MuteType.class);
    }

    public String getPlayerKey() {
        return this.playerKey;
    }

    public Map<MuteType, MuteDetail> getActiveMutes() {
        return new EnumMap<MuteType, MuteDetail>(this.activeMutes);
    }

    public void addMute(MuteType type, MuteDetail detail) {
        this.activeMutes.put(type, detail);
    }

    public void removeMute(MuteType type) {
        this.activeMutes.remove((Object)type);
    }

    public MuteDetail getMuteDetail(MuteType type) {
        return this.activeMutes.get((Object)type);
    }

    public boolean isMuted(MuteType type) {
        MuteDetail detail = this.activeMutes.get((Object)type);
        return detail != null && !detail.isExpired();
    }

    public boolean isMutedAny() {
        return this.activeMutes.values().stream().anyMatch(detail -> !detail.isExpired());
    }

    public void cleanupExpiredMutes() {
        this.activeMutes.entrySet().removeIf(entry -> ((MuteDetail)entry.getValue()).isExpired());
    }

    public boolean isEmpty() {
        return this.activeMutes.isEmpty();
    }
}

