/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.mute;

import ethertaco.sundries.Sundries;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class MuteDetail {
    private String reason;
    private UUID muterUUID;
    private long startTimeMillis;
    private long endTimeMillis;

    public MuteDetail(String reason, UUID muterUUID, long durationMillis) {
        this.reason = reason;
        this.muterUUID = muterUUID;
        this.startTimeMillis = System.currentTimeMillis();
        this.endTimeMillis = durationMillis == 0L ? 0L : this.startTimeMillis + durationMillis;
    }

    public MuteDetail(String reason, UUID muterUUID, long startTimeMillis, long endTimeMillis) {
        this.reason = reason;
        this.muterUUID = muterUUID;
        this.startTimeMillis = startTimeMillis;
        this.endTimeMillis = endTimeMillis;
    }

    public String getReason() {
        return this.reason;
    }

    public UUID getMuterUUID() {
        return this.muterUUID;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public long getEndTimeMillis() {
        return this.endTimeMillis;
    }

    public boolean isPermanent() {
        return this.endTimeMillis == 0L;
    }

    public boolean isExpired() {
        return !this.isPermanent() && System.currentTimeMillis() >= this.endTimeMillis;
    }

    public long getRemainingMillis() {
        if (this.isPermanent()) {
            return -1L;
        }
        long remaining = this.endTimeMillis - System.currentTimeMillis();
        return Math.max(0L, remaining);
    }

    public String getFormattedRemainingTime() {
        long remaining = this.getRemainingMillis();
        if (remaining == -1L) {
            return Sundries.getInstance().getLangManager().getMessage("duration.permanent");
        }
        if (remaining <= 0L) {
            return "0s";
        }
        long days = TimeUnit.MILLISECONDS.toDays(remaining);
        long hours = TimeUnit.MILLISECONDS.toHours(remaining -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(remaining -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(remaining -= TimeUnit.MINUTES.toMillis(minutes));
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        if (seconds > 0L || sb.length() == 0) {
            sb.append(seconds).append("s");
        }
        return sb.toString().trim();
    }
}

