/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.mute;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.modules.mute.MuteDetail;
import ethertaco.sundries.modules.mute.MuteEntry;
import ethertaco.sundries.modules.mute.MuteType;
import java.io.File;
import java.io.IOException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MuteConfig {
    private final Sundries plugin;
    private File muteConfigFile;
    private FileConfiguration muteConfig;
    private final Map<String, MuteEntry> loadedMutes = new HashMap<String, MuteEntry>();

    public MuteConfig(Sundries plugin) {
        this.plugin = plugin;
        this.setupMuteConfig();
        this.loadConfig();
    }

    private void setupMuteConfig() {
        File modulesFolder = new File(this.plugin.getDataFolder(), "modules");
        if (!modulesFolder.exists()) {
            modulesFolder.mkdirs();
        }
        this.muteConfigFile = new File(modulesFolder, "mute.yml");
        if (!this.muteConfigFile.exists()) {
            this.plugin.saveResource("modules/mute.yml", false);
        }
        this.muteConfig = YamlConfiguration.loadConfiguration((File)this.muteConfigFile);
    }

    public void reloadConfig() {
        this.muteConfig = YamlConfiguration.loadConfiguration((File)this.muteConfigFile);
        this.loadConfig();
        this.plugin.getLogger().info("modules/mute.yml reloaded.");
    }

    private void loadConfig() {
        this.loadedMutes.clear();
        ConfigurationSection muteSection = this.muteConfig.getConfigurationSection("mutes");
        if (muteSection == null) {
            return;
        }
        for (String playerKey : muteSection.getKeys(false)) {
            ConfigurationSection playerMuteSection = muteSection.getConfigurationSection(playerKey);
            if (playerMuteSection == null) continue;
            EnumMap<MuteType, MuteDetail> activeMutes = new EnumMap<MuteType, MuteDetail>(MuteType.class);
            for (String typeName : playerMuteSection.getKeys(false)) {
                try {
                    long endTime;
                    long startTime;
                    UUID muterUUID;
                    String reason;
                    MuteDetail detail;
                    MuteType type = MuteType.valueOf(typeName.toUpperCase());
                    ConfigurationSection detailSection = playerMuteSection.getConfigurationSection(typeName);
                    if (detailSection == null || (detail = new MuteDetail(reason = detailSection.getString("reason", ""), muterUUID = UUID.fromString(detailSection.getString("muter-uuid", "00000000-0000-0000-0000-000000000000")), startTime = detailSection.getLong("start-time"), endTime = detailSection.getLong("end-time"))).isExpired()) continue;
                    activeMutes.put(type, detail);
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Invalid MuteType found in mute.yml for key '" + playerKey + "': " + typeName);
                }
            }
            if (activeMutes.isEmpty()) continue;
            this.loadedMutes.put(playerKey, new MuteEntry(playerKey, activeMutes));
        }
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[MuteConfig] Loaded %d active mute entries from config.", this.loadedMutes.size()));
        }
    }

    public void saveConfig() {
        this.muteConfig.set("mutes", null);
        ConfigurationSection mutesSection = this.muteConfig.createSection("mutes");
        for (MuteEntry entry : this.loadedMutes.values()) {
            entry.cleanupExpiredMutes();
            if (entry.isEmpty()) continue;
            ConfigurationSection playerMuteSection = mutesSection.createSection(entry.getPlayerKey());
            for (Map.Entry<MuteType, MuteDetail> muteEntry : entry.getActiveMutes().entrySet()) {
                MuteType type = muteEntry.getKey();
                MuteDetail detail = muteEntry.getValue();
                ConfigurationSection detailSection = playerMuteSection.createSection(type.name().toLowerCase());
                detailSection.set("reason", (Object)detail.getReason());
                detailSection.set("muter-uuid", (Object)detail.getMuterUUID().toString());
                detailSection.set("start-time", (Object)detail.getStartTimeMillis());
                detailSection.set("end-time", (Object)detail.getEndTimeMillis());
            }
        }
        try {
            this.muteConfig.save(this.muteConfigFile);
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[MuteConfig] Saved %d mute entries to config.", this.loadedMutes.size()));
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save modules/mute.yml: " + e.getMessage());
        }
    }

    public MuteEntry getMuteEntry(String playerKey) {
        MuteEntry entry = this.loadedMutes.get(playerKey);
        if (entry != null) {
            entry.cleanupExpiredMutes();
            if (entry.isEmpty()) {
                this.loadedMutes.remove(playerKey);
                return null;
            }
        }
        return entry;
    }

    public void saveMuteEntry(MuteEntry entry) {
        if (entry == null || entry.isEmpty()) {
            if (entry != null) {
                this.loadedMutes.remove(entry.getPlayerKey());
            }
        } else {
            this.loadedMutes.put(entry.getPlayerKey(), entry);
        }
        this.saveConfig();
    }

    public void removeMuteEntry(String playerKey) {
        this.loadedMutes.remove(playerKey);
        this.saveConfig();
    }

    public Set<String> getAllMutedPlayerKeys() {
        this.loadedMutes.entrySet().removeIf(entry -> {
            ((MuteEntry)entry.getValue()).cleanupExpiredMutes();
            return ((MuteEntry)entry.getValue()).isEmpty();
        });
        return new HashSet<String>(this.loadedMutes.keySet());
    }

    public void clearAllPlayerData() {
        this.loadedMutes.clear();
        this.saveConfig();
        this.plugin.getLogger().info("All player data has been cleared from mute.yml.");
    }

    public boolean isBroadcastOnMute() {
        return this.muteConfig.getBoolean("mute-settings.broadcast-on-mute", true);
    }

    public boolean isBroadcastOnUnmute() {
        return this.muteConfig.getBoolean("mute-settings.broadcast-on-unmute", true);
    }
}

