/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.mute;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.commands.AbstractCommand;
import ethertaco.sundries.modules.mute.MuteManager;
import ethertaco.sundries.modules.mute.MuteType;
import ethertaco.sundries.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MuteCommand
extends AbstractCommand {
    private final MuteManager muteManager;

    public MuteCommand(Sundries plugin) {
        super(plugin, "mute", "sundries.command.mute");
        this.muteManager = plugin.getMuteManager();
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        String requiredPermission;
        boolean isSelfMute;
        long durationMillis;
        String potentialTypeOrDuration;
        if (!this.plugin.getConfigManager().isPluginEnabled() || !this.plugin.getFeatureToggleManager().getDefaultGlobalFeatureStatus("mute")) {
            MessageUtils.sendError(sender, "command.mute.feature_disabled", new Object[0]);
            return true;
        }
        if (args.length < 1) {
            this.sendUsage(sender, "/mute <player> [chat|command|all] [duration] [reason]");
            return false;
        }
        String targetPlayerName = args[0];
        Player targetPlayer = Bukkit.getPlayer((String)targetPlayerName);
        if (targetPlayer == null) {
            MessageUtils.sendError(sender, "command.not_online", "player_name", targetPlayerName);
            return true;
        }
        MuteType muteType = MuteType.ALL;
        String durationString = null;
        String reason = this.plugin.getLangManager().getMessage("mute.default_reason");
        int argIndex = 1;
        if (args.length > argIndex && ((potentialTypeOrDuration = args[argIndex].toLowerCase()).equals("chat") || potentialTypeOrDuration.equals("command") || potentialTypeOrDuration.equals("all"))) {
            muteType = MuteType.valueOf(potentialTypeOrDuration.toUpperCase());
            ++argIndex;
        }
        if (args.length > argIndex) {
            durationString = args[argIndex];
            if (this.parseDuration(durationString) == -1L) {
                durationString = null;
            } else {
                ++argIndex;
            }
        }
        if (args.length > argIndex) {
            reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, argIndex, args.length));
        }
        if ((durationMillis = this.parseDuration(durationString)) == -1L) {
            MessageUtils.sendError(sender, "command.mute.invalid_duration", "duration_arg", args[argIndex - 1]);
            return true;
        }
        boolean bl = isSelfMute = sender instanceof Player && sender.getName().equalsIgnoreCase(targetPlayer.getName());
        if (muteType == MuteType.ALL) {
            requiredPermission = isSelfMute ? "sundries.command.mute.all.self" : "sundries.command.mute.all.others";
        } else if (muteType == MuteType.CHAT) {
            requiredPermission = isSelfMute ? "sundries.command.mute.chat.self" : "sundries.command.mute.chat.others";
        } else {
            String string = requiredPermission = isSelfMute ? "sundries.command.mute.command.self" : "sundries.command.mute.command.others";
        }
        if (!sender.hasPermission(requiredPermission)) {
            MessageUtils.sendError(sender, "command.no_permission", "permission", requiredPermission);
            return true;
        }
        this.muteManager.mutePlayer(targetPlayer, muteType, durationMillis, reason, sender, true);
        return true;
    }

    private long parseDuration(String durationString) {
        if (durationString == null || durationString.equalsIgnoreCase("permanent") || durationString.equalsIgnoreCase("perm")) {
            return 0L;
        }
        try {
            char unit = durationString.toLowerCase().charAt(durationString.length() - 1);
            long value = Long.parseLong(durationString.substring(0, durationString.length() - 1));
            switch (unit) {
                case 's': {
                    return TimeUnit.SECONDS.toMillis(value);
                }
                case 'm': {
                    return TimeUnit.MINUTES.toMillis(value);
                }
                case 'h': {
                    return TimeUnit.HOURS.toMillis(value);
                }
                case 'd': {
                    return TimeUnit.DAYS.toMillis(value);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        String currentArg;
        if (!this.checkPermission(sender)) {
            return Collections.emptyList();
        }
        ArrayList<String> completions = new ArrayList<String>();
        String string = currentArg = args.length > 0 ? args[args.length - 1].toLowerCase() : "";
        if (args.length == 1) {
            completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(currentArg)).collect(Collectors.toList()));
        } else if (args.length == 2) {
            if ("chat".startsWith(currentArg)) {
                completions.add("chat");
            }
            if ("command".startsWith(currentArg)) {
                completions.add("command");
            }
            if ("all".startsWith(currentArg)) {
                completions.add("all");
            }
        } else if (args.length == 3) {
            completions.addAll(Arrays.asList("1m", "5m", "1h", "1d", "7d", "permanent").stream().filter(s -> s.startsWith(currentArg)).collect(Collectors.toList()));
        }
        return completions;
    }
}

