/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.mute;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.commands.AbstractCommand;
import ethertaco.sundries.modules.mute.MuteDetail;
import ethertaco.sundries.modules.mute.MuteEntry;
import ethertaco.sundries.modules.mute.MuteType;
import ethertaco.sundries.utils.MessageUtils;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CheckMuteCommand
extends AbstractCommand {
    public CheckMuteCommand(Sundries plugin) {
        super(plugin, "checkmute", "sundries.command.mute.check");
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!this.plugin.getConfigManager().isPluginEnabled() || !this.plugin.getFeatureToggleManager().getDefaultGlobalFeatureStatus("mute")) {
            MessageUtils.sendError(sender, "command.mute.feature_disabled", new Object[0]);
            return true;
        }
        if (args.length == 0) {
            this.sendUsage(sender, "/checkmute <player>");
            return false;
        }
        if (!sender.hasPermission("sundries.command.mute.check")) {
            MessageUtils.sendError(sender, "command.no_permission", "permission", "sundries.command.mute.check");
            return true;
        }
        String targetPlayerName = args[0];
        OfflinePlayer targetOfflinePlayer = Bukkit.getOfflinePlayer((String)targetPlayerName);
        if (!targetOfflinePlayer.hasPlayedBefore() && !targetOfflinePlayer.isOnline()) {
            MessageUtils.sendError(sender, "command.player_not_found", "player_name", targetPlayerName);
            return false;
        }
        String playerKey = this.plugin.getConfigManager().getOfflinePlayerStorageKey(targetOfflinePlayer, "mute");
        String displayPlayerName = targetOfflinePlayer.getName();
        MuteEntry entry = this.plugin.getMuteConfig().getMuteEntry(playerKey);
        this.displayMuteStatus(sender, displayPlayerName, entry);
        return true;
    }

    private void displayMuteStatus(CommandSender sender, String playerName, MuteEntry entry) {
        MessageUtils.sendInfo(sender, "command.mute.status_header", "player_name", playerName);
        if (entry == null || entry.isEmpty()) {
            MessageUtils.sendInfo(sender, "command.mute.status_not_muted", new Object[0]);
        } else {
            entry.cleanupExpiredMutes();
            if (entry.isEmpty()) {
                MessageUtils.sendInfo(sender, "command.mute.status_not_muted", new Object[0]);
                this.plugin.getMuteConfig().saveMuteEntry(entry);
                return;
            }
            boolean anyMuteFound = false;
            for (MuteType type : MuteType.values()) {
                MuteDetail detail;
                if (type == MuteType.ALL || (detail = entry.getMuteDetail(type)) == null || detail.isExpired()) continue;
                anyMuteFound = true;
                String muterName = "Console";
                if (detail.getMuterUUID() != null && !detail.getMuterUUID().equals(new UUID(0L, 0L))) {
                    OfflinePlayer muter = Bukkit.getOfflinePlayer((UUID)detail.getMuterUUID());
                    muterName = muter.getName() != null ? muter.getName() : "Unknown";
                }
                String durationInfo = detail.isPermanent() ? this.plugin.getLangManager().getMessage("duration.permanent") : this.plugin.getLangManager().getMessage("duration.remaining", "remaining_time", detail.getFormattedRemainingTime());
                MessageUtils.sendInfo(sender, "command.mute.status_entry", "mute_type", type.name().toLowerCase(), "reason", detail.getReason(), "muter_name", muterName, "duration_info", durationInfo);
            }
            if (!anyMuteFound) {
                MessageUtils.sendInfo(sender, "command.mute.status_not_muted", new Object[0]);
            }
        }
        MessageUtils.sendInfo(sender, "command.mute.status_footer", new Object[0]);
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (!this.checkPermission(sender)) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            String currentArg = args[0].toLowerCase();
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(currentArg)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

