/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.god;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.modules.god.GodConfig;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;

public class GodManager {
    private final Sundries plugin;
    private final GodConfig godConfig;
    private final Set<UUID> onlineGodModePlayers = new HashSet<UUID>();

    public GodManager(Sundries plugin, GodConfig godConfig) {
        this.plugin = plugin;
        this.godConfig = godConfig;
    }

    public void setGodMode(Player player, boolean enabled) {
        String playerKey = this.plugin.getConfigManager().getPlayerStorageKey(player, "god");
        UUID playerUUID = player.getUniqueId();
        if (enabled) {
            this.onlineGodModePlayers.add(playerUUID);
            player.setInvulnerable(true);
            AttributeInstance maxHealthAttribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            if (maxHealthAttribute != null) {
                player.setHealth(maxHealthAttribute.getValue());
            } else {
                player.setHealth(20.0);
            }
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[GodManager] Player %s (key: %s) entered god mode.", player.getName(), playerKey));
            }
        } else {
            this.onlineGodModePlayers.remove(playerUUID);
            player.setInvulnerable(false);
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[GodManager] Player %s (key: %s) exited god mode.", player.getName(), playerKey));
            }
        }
        this.godConfig.setGod(playerKey, enabled);
    }

    public boolean isGodMode(Player player) {
        return this.onlineGodModePlayers.contains(player.getUniqueId());
    }

    public void loadPlayer(Player player) {
        String playerKey = this.plugin.getConfigManager().getPlayerStorageKey(player, "god");
        if (this.godConfig.isGod(playerKey)) {
            this.onlineGodModePlayers.add(player.getUniqueId());
            player.setInvulnerable(true);
            AttributeInstance maxHealthAttribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            if (maxHealthAttribute != null) {
                player.setHealth(maxHealthAttribute.getValue());
            }
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine("Restored god mode for " + player.getName());
            }
        } else {
            this.onlineGodModePlayers.remove(player.getUniqueId());
            player.setInvulnerable(false);
        }
    }

    public void unloadPlayer(Player player) {
        this.onlineGodModePlayers.remove(player.getUniqueId());
        if (player.isInvulnerable()) {
            player.setInvulnerable(false);
        }
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[GodManager] Player %s went offline, unloaded from memory.", player.getName()));
        }
    }
}

