/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.god;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.modules.god.GodManager;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;

public class GodListener
implements Listener {
    private final Sundries plugin;
    private final GodManager godManager;

    public GodListener(Sundries plugin) {
        this.plugin = plugin;
        this.godManager = plugin.getGodManager();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (!this.godManager.isGodMode(player)) {
            return;
        }
        if (this.plugin.getConfigManager().isGodModeBypassKill() && (event.getCause() == EntityDamageEvent.DamageCause.CUSTOM || event.getCause() == EntityDamageEvent.DamageCause.SUICIDE || event.getCause() == EntityDamageEvent.DamageCause.VOID)) {
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[GodListener] God mode for %s bypassed by damage cause %s. Allowing damage.", player.getName(), event.getCause().name()));
            }
            return;
        }
        event.setCancelled(true);
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[GodListener] Prevented god mode player %s from taking damage (%s).", player.getName(), event.getCause().name()));
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.godManager.loadPlayer(event.getPlayer()), 1L);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.godManager.unloadPlayer(event.getPlayer());
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.godManager.loadPlayer(event.getPlayer()), 1L);
    }
}

