/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.god;

import ethertaco.sundries.Sundries;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class GodConfig {
    private final Sundries plugin;
    private File godConfigFile;
    private FileConfiguration godConfig;
    private Set<String> godPlayers;

    public GodConfig(Sundries plugin) {
        this.plugin = plugin;
        this.setupGodConfig();
        this.loadGodPlayers();
    }

    private void setupGodConfig() {
        File modulesFolder = new File(this.plugin.getDataFolder(), "modules");
        if (!modulesFolder.exists()) {
            modulesFolder.mkdirs();
        }
        this.godConfigFile = new File(modulesFolder, "god.yml");
        if (!this.godConfigFile.exists()) {
            this.plugin.saveResource("modules/god.yml", false);
        }
        this.godConfig = YamlConfiguration.loadConfiguration((File)this.godConfigFile);
    }

    private void loadGodPlayers() {
        this.godPlayers = new HashSet<String>(this.godConfig.getStringList("god-players"));
    }

    public void reloadConfig() {
        this.godConfig = YamlConfiguration.loadConfiguration((File)this.godConfigFile);
        this.loadGodPlayers();
        this.plugin.getLogger().info("modules/god.yml reloaded.");
    }

    public void saveConfig() {
        this.godConfig.set("god-players", new ArrayList<String>(this.godPlayers));
        try {
            this.godConfig.save(this.godConfigFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save modules/god.yml: " + e.getMessage());
        }
    }

    public boolean isGod(String playerKey) {
        return this.godPlayers.contains(playerKey);
    }

    public void setGod(String playerKey, boolean enabled) {
        if (enabled) {
            this.godPlayers.add(playerKey);
        } else {
            this.godPlayers.remove(playerKey);
        }
        this.saveConfig();
    }

    public Set<String> getGodPlayers() {
        return new HashSet<String>(this.godPlayers);
    }

    public void clearAllPlayerData() {
        this.godPlayers.clear();
        this.saveConfig();
        this.plugin.getLogger().info("All player data has been cleared from god.yml.");
    }
}

