/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.god;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.commands.AbstractCommand;
import ethertaco.sundries.modules.god.GodManager;
import ethertaco.sundries.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GodCommand
extends AbstractCommand {
    private final GodManager godManager;

    public GodCommand(Sundries plugin) {
        super(plugin, "god", "sundries.command.god.self");
        this.godManager = plugin.getGodManager();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean execute(CommandSender sender, String[] args) {
        Player targetPlayer = null;
        Boolean newState = null;
        if (args.length == 0) {
            if (!this.isPlayer(sender)) {
                return true;
            }
            targetPlayer = (Player)sender;
            if (!sender.hasPermission("sundries.command.god.self")) {
                MessageUtils.sendError(sender, "command.no_permission", "permission", "sundries.command.god.self");
                return true;
            }
        } else if (args.length == 1) {
            String arg0 = args[0].toLowerCase();
            if (arg0.equals("on") || arg0.equals("off")) {
                if (!this.isPlayer(sender)) {
                    return true;
                }
                targetPlayer = (Player)sender;
                if (!sender.hasPermission("sundries.command.god.self")) {
                    MessageUtils.sendError(sender, "command.no_permission", "permission", "sundries.command.god.self");
                    return true;
                }
                newState = arg0.equals("on");
            } else {
                if (!sender.hasPermission("sundries.command.god.others")) {
                    MessageUtils.sendError(sender, "command.no_permission", "permission", "sundries.command.god.others");
                    return true;
                }
                targetPlayer = Bukkit.getPlayer((String)args[0]);
            }
        } else {
            if (args.length != 2) {
                this.sendUsage(sender, "/su god [player] [on|off]");
                return false;
            }
            if (!sender.hasPermission("sundries.command.god.others")) {
                MessageUtils.sendError(sender, "command.no_permission", "permission", "sundries.command.god.others");
                return true;
            }
            targetPlayer = Bukkit.getPlayer((String)args[0]);
            String arg1 = args[1].toLowerCase();
            if (!arg1.equals("on") && !arg1.equals("off")) {
                this.sendUsage(sender, "/su god [player] [on|off]");
                return false;
            }
            newState = arg1.equals("on");
        }
        if (targetPlayer == null) {
            MessageUtils.sendError(sender, "command.not_online", "player_name", args[0]);
            return false;
        }
        if (!this.plugin.getFeatureToggleManager().isFeatureEnabled(targetPlayer, "god")) {
            MessageUtils.sendError(sender, "command.god.feature_disabled_for_player", "player_name", targetPlayer.getName());
            return true;
        }
        boolean finalState = newState == null ? !this.godManager.isGodMode(targetPlayer) : newState;
        this.godManager.setGodMode(targetPlayer, finalState);
        String senderName = sender.getName();
        if (finalState) {
            if (sender == targetPlayer) {
                MessageUtils.sendSuccess(sender, "command.god.enabled_self", new Object[0]);
                return true;
            }
            MessageUtils.sendSuccess(sender, "command.god.enabled_other", "player_name", targetPlayer.getName());
            MessageUtils.sendMessage((Audience)targetPlayer, "command.god.enabled_by_other", "sender_name", senderName);
            return true;
        }
        if (sender == targetPlayer) {
            MessageUtils.sendSuccess(sender, "command.god.disabled_self", new Object[0]);
            return true;
        }
        MessageUtils.sendSuccess(sender, "command.god.disabled_other", "player_name", targetPlayer.getName());
        MessageUtils.sendMessage((Audience)targetPlayer, "command.god.disabled_by_other", "sender_name", senderName);
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            if (sender.hasPermission("sundries.command.god.self")) {
                completions.addAll(Arrays.asList("on", "off"));
            }
            if (sender.hasPermission("sundries.command.god.others")) {
                completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList()));
            }
            return completions.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && sender.hasPermission("sundries.command.god.others")) {
            return Arrays.asList("on", "off").stream().filter(s -> s.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

