/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.furnace;

import ethertaco.sundries.config.ConfigManager;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bukkit.World;

public class FurnaceSpeedManager {
    private final ConfigManager configManager;

    public FurnaceSpeedManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public double getEffectiveFurnaceSpeed(World world, String furnaceType) {
        return this.configManager.getFurnaceSpeed(world.getName(), furnaceType);
    }

    public void setFurnaceSpeed(String dimensionName, String furnaceType, double speedPercentage) {
        this.configManager.setFurnaceSpeed(dimensionName.toLowerCase(Locale.ROOT), furnaceType.toUpperCase(Locale.ROOT), speedPercentage);
    }

    public void resetFurnaceSpeed(String dimensionName, String furnaceType) {
        this.configManager.resetFurnaceSpeed(dimensionName.toLowerCase(Locale.ROOT), furnaceType.toUpperCase(Locale.ROOT));
    }

    public static boolean isValidFurnaceType(String typeString) {
        String upperType = typeString.toUpperCase(Locale.ROOT);
        return upperType.equals("FURNACE") || upperType.equals("BLAST_FURNACE") || upperType.equals("SMOKER");
    }

    public Set<String> getConfiguredDimensions() {
        return this.configManager.getFurnaceSpeedDimensions();
    }

    public Map<String, Double> getDimensionSpeeds(String dimensionName) {
        if (dimensionName.equalsIgnoreCase("global")) {
            return this.configManager.getGlobalFurnaceSpeeds();
        }
        return this.configManager.getFurnaceSpeedsForDimension(dimensionName.toLowerCase(Locale.ROOT));
    }
}

