/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.furnace;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.config.ConfigManager;
import ethertaco.sundries.modules.furnace.FurnaceSpeedManager;
import org.bukkit.block.Furnace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;

public class FurnaceListener
implements Listener {
    private final Sundries plugin;
    private final FurnaceSpeedManager furnaceSpeedManager;
    private final ConfigManager configManager;

    public FurnaceListener(Sundries plugin) {
        this.plugin = plugin;
        this.furnaceSpeedManager = plugin.getFurnaceSpeedManager();
        this.configManager = plugin.getConfigManager();
    }

    @EventHandler
    public void onFurnaceBurn(FurnaceBurnEvent event) {
        if (!this.configManager.isPluginEnabled()) {
            return;
        }
        Furnace furnace = (Furnace)event.getBlock().getState();
        String furnaceType = furnace.getType().name();
        String worldName = event.getBlock().getWorld().getName();
        double speedPercentage = this.furnaceSpeedManager.getEffectiveFurnaceSpeed(event.getBlock().getWorld(), furnaceType);
        if (speedPercentage != 100.0) {
            int originalBurnTime = event.getBurnTime();
            int newBurnTime = (int)((double)originalBurnTime / (speedPercentage / 100.0));
            event.setBurnTime(Math.max(1, newBurnTime));
            if (this.configManager.getDebugMode()) {
                this.plugin.getLogger().info(String.format("[FurnaceListener] Burn: Type=%s, World=%s, OriginalBurnTime=%d, Speed=%.1f%%, NewBurnTime=%d", furnaceType, worldName, originalBurnTime, speedPercentage, newBurnTime));
            }
        }
    }

    @EventHandler
    public void onFurnaceStartSmelt(FurnaceStartSmeltEvent event) {
        if (!this.configManager.isPluginEnabled()) {
            return;
        }
        Furnace furnace = (Furnace)event.getBlock().getState();
        String furnaceType = furnace.getType().name();
        String worldName = furnace.getWorld().getName();
        double speedPercentage = this.furnaceSpeedManager.getEffectiveFurnaceSpeed(furnace.getWorld(), furnaceType);
        if (speedPercentage != 100.0) {
            int originalTotalCookTime = event.getTotalCookTime();
            int newCookTimeTotal = (int)((double)originalTotalCookTime / (speedPercentage / 100.0));
            event.setTotalCookTime(Math.max(1, newCookTimeTotal));
            if (this.configManager.getDebugMode()) {
                this.plugin.getLogger().info(String.format("[FurnaceListener] Smelt: Type=%s, World=%s, OriginalCookTime=%d, Speed=%.1f%%, NewCookTime=%d", furnaceType, worldName, originalTotalCookTime, speedPercentage, newCookTimeTotal));
            }
        }
    }
}

