/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.furnace;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.commands.AbstractCommand;
import ethertaco.sundries.modules.furnace.FurnaceSpeedManager;
import ethertaco.sundries.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.generator.WorldInfo;

public class FurnaceCommand
extends AbstractCommand {
    public FurnaceCommand(Sundries plugin) {
        super(plugin, "furnace", "sundries.admin.furnace");
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        World world;
        if (!this.checkPermission(sender)) {
            return true;
        }
        if (args.length < 3 || args.length > 3) {
            this.sendUsage(sender, "/su furnace <dimension_name|global> <furnace|blast_furnace|smoker> <speed(0-1000)|default>");
            MessageUtils.sendInfo(sender, "\u793a\u4f8b: <aqua>/su furnace global furnace 200</aqua> (2\u500d\u666e\u901a\u7194\u7089\u901f\u5ea6)", new Object[0]);
            MessageUtils.sendInfo(sender, "\u793a\u4f8b: <aqua>/su furnace world_nether blast_furnace default</aqua> (\u91cd\u7f6e\u5730\u72f1\u9ad8\u7089\u901f\u5ea6)", new Object[0]);
            return false;
        }
        String dimensionName = args[0].toLowerCase();
        String furnaceType = args[1].toUpperCase();
        String speedArg = args[2].toLowerCase();
        if (!dimensionName.equals("global") && (world = Bukkit.getWorld((String)dimensionName)) == null) {
            MessageUtils.sendError(sender, "command.furnace.invalid_dimension", "dimension_name", dimensionName);
            return false;
        }
        if (!FurnaceSpeedManager.isValidFurnaceType(furnaceType)) {
            MessageUtils.sendError(sender, "command.furnace.invalid_type", "furnace_type", furnaceType);
            return false;
        }
        if (speedArg.equals("default")) {
            this.plugin.getFurnaceSpeedManager().resetFurnaceSpeed(dimensionName, furnaceType);
            MessageUtils.sendSuccess(sender, "command.furnace.reset_success", "dimension_name", dimensionName, "furnace_type", furnaceType);
        } else {
            try {
                double speed = Double.parseDouble(speedArg);
                if (speed < 0.0 || speed > 1000.0) {
                    MessageUtils.sendError(sender, "command.furnace.speed_out_of_range", new Object[0]);
                    return false;
                }
                this.plugin.getFurnaceSpeedManager().setFurnaceSpeed(dimensionName, furnaceType, speed);
                MessageUtils.sendSuccess(sender, "command.furnace.set_success", "dimension_name", dimensionName, "furnace_type", furnaceType, "speed_percentage", String.valueOf(speed));
            }
            catch (NumberFormatException e) {
                MessageUtils.sendError(sender, "command.furnace.invalid_speed_value", "speed_arg", speedArg);
                return false;
            }
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (!sender.hasPermission(this.permission)) {
            return Collections.emptyList();
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("global");
            Bukkit.getWorlds().stream().map(WorldInfo::getName).filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).forEach(completions::add);
        } else {
            if (args.length == 2) {
                return Arrays.asList("furnace", "blast_furnace", "smoker").stream().filter(s -> s.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            if (args.length == 3) {
                completions.add("default");
                Arrays.asList("100", "200", "500", "1000").stream().filter(s -> s.startsWith(args[2])).forEach(completions::add);
            }
        }
        return completions.stream().filter(s -> s.toLowerCase().startsWith(args[args.length - 1].toLowerCase())).collect(Collectors.toList());
    }
}

