/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.fly;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.commands.AbstractCommand;
import ethertaco.sundries.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FlySpeedCommand
extends AbstractCommand {
    public FlySpeedCommand(Sundries plugin) {
        super(plugin, "flyspeed", "sundries.command.flyspeed");
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        double speedPercentage;
        Player targetPlayer = null;
        if (args.length == 1) {
            if (!this.isPlayer(sender)) {
                return true;
            }
            targetPlayer = (Player)sender;
            if (!sender.hasPermission("sundries.command.flyspeed")) {
                MessageUtils.sendError(sender, "command.no_permission", "permission", "sundries.command.flyspeed");
                return true;
            }
            try {
                speedPercentage = Double.parseDouble(args[0]);
            }
            catch (NumberFormatException e) {
                this.sendUsage(sender, "/su flyspeed <10-500> [player_name]");
                MessageUtils.sendError(sender, "command.flyspeed.invalid_speed_value", "speed_arg", args[0]);
                return false;
            }
        }
        if (args.length == 2) {
            if (!sender.hasPermission("sundries.command.flyspeed.others")) {
                MessageUtils.sendError(sender, "command.no_permission", "permission", "sundries.command.flyspeed.others");
                return true;
            }
            try {
                speedPercentage = Double.parseDouble(args[0]);
            }
            catch (NumberFormatException e) {
                this.sendUsage(sender, "/su flyspeed <10-500> [player_name]");
                MessageUtils.sendError(sender, "command.flyspeed.invalid_speed_value", "speed_arg", args[0]);
                return false;
            }
            targetPlayer = Bukkit.getPlayer((String)args[1]);
            if (targetPlayer == null) {
                MessageUtils.sendError(sender, "command.not_online", "player_name", args[1]);
                return false;
            }
        } else {
            this.sendUsage(sender, "/su flyspeed <10-500> [player_name]");
            return false;
        }
        if (targetPlayer == null) {
            MessageUtils.sendError(sender, "command.player_not_found", "player_name", args.length == 2 ? args[1] : "");
            return false;
        }
        if (!this.plugin.getFeatureToggleManager().isFeatureEnabled(targetPlayer, "fly_speed_control")) {
            MessageUtils.sendError(sender, "command.flyspeed.feature_disabled_for_player", "player_name", targetPlayer.getName());
            return true;
        }
        if (speedPercentage < 10.0 || speedPercentage > 500.0) {
            MessageUtils.sendError(sender, "command.flyspeed.speed_out_of_range", new Object[0]);
            return false;
        }
        this.plugin.getFlyManager().setPlayerFlySpeed(targetPlayer, speedPercentage);
        if (targetPlayer.isFlying()) {
            this.plugin.getFlyManager().applyPlayerFlySpeed(targetPlayer, speedPercentage);
        }
        String senderName = sender instanceof Player ? sender.getName() : "Console";
        MessageUtils.sendSuccess(sender, "command.flyspeed.set", "speed_percentage", String.valueOf(speedPercentage), "player_name", targetPlayer.getName());
        if (sender != targetPlayer) {
            MessageUtils.sendMessage((Audience)targetPlayer, "command.flyspeed.set_by_other", "speed_percentage", String.valueOf(speedPercentage), "sender_name", senderName);
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (!this.checkPermission(sender)) {
            return Collections.emptyList();
        }
        ArrayList completions = new ArrayList();
        if (args.length == 1) {
            return Arrays.asList("100", "200", "500").stream().filter(s -> s.startsWith(args[0])).collect(Collectors.toList());
        }
        if (args.length == 2 && sender.hasPermission("sundries.command.flyspeed.others")) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

