/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.fly;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.modules.fly.FlyConfig;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;

public class FlyManager {
    private final Sundries plugin;
    private final FlyConfig flyConfig;
    public static final float DEFAULT_FLY_SPEED_BUKKIT = 0.1f;
    private boolean allowFlyInSurvival = false;

    public FlyManager(Sundries plugin, FlyConfig flyConfig) {
        this.plugin = plugin;
        this.flyConfig = flyConfig;
    }

    public void setAllowFlyInSurvival(boolean allow) {
        this.allowFlyInSurvival = allow;
    }

    public void setPlayerFlight(Player player, boolean enabled) {
        String playerKey = this.plugin.getConfigManager().getPlayerStorageKey(player, "fly");
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[FlyManager] setPlayerFlight for %s (key: %s): enabled=%s, currentGM=%s", player.getName(), playerKey, enabled, player.getGameMode().name()));
        }
        if (!this.isFlightAllowedByCurrentGamemode(player, enabled)) {
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[FlyManager] setPlayerFlight for %s: Not allowed by gamemode. Disabling flight.", player.getName()));
            }
            player.setAllowFlight(false);
            player.setFlying(false);
            this.flyConfig.setFlyEnabled(playerKey, false);
            return;
        }
        player.setAllowFlight(enabled);
        player.setFlying(enabled);
        if (enabled) {
            this.applyPlayerFlySpeed(player, this.flyConfig.getFlySpeed(playerKey));
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[FlyManager] setPlayerFlight for %s: Flight ENABLED. Speed applied.", player.getName()));
            }
        } else {
            player.setFlySpeed(0.1f);
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[FlyManager] setPlayerFlight for %s: Flight DISABLED. Speed reset.", player.getName()));
            }
        }
        this.flyConfig.setFlyEnabled(playerKey, enabled);
    }

    public void setPlayerFlySpeed(Player player, double speedPercentage) {
        String playerKey = this.plugin.getConfigManager().getPlayerStorageKey(player, "fly");
        float bukkitSpeed = (float)((double)0.1f * (speedPercentage / 100.0));
        player.setFlySpeed(Math.min(1.0f, Math.max(-1.0f, bukkitSpeed)));
        this.flyConfig.setFlySpeed(playerKey, speedPercentage);
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[FlyManager] setPlayerFlySpeed for %s: Speed set to %.1f%% (Bukkit: %.3f)", player.getName(), speedPercentage, Float.valueOf(player.getFlySpeed())));
        }
    }

    public void applyPlayerFlySpeed(Player player, double speedPercentage) {
        float bukkitSpeed = (float)((double)0.1f * (speedPercentage / 100.0));
        player.setFlySpeed(Math.min(1.0f, Math.max(-1.0f, bukkitSpeed)));
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[FlyManager] applyPlayerFlySpeed for %s: Applied %.1f%% (Bukkit: %.3f)", player.getName(), speedPercentage, Float.valueOf(player.getFlySpeed())));
        }
    }

    public boolean getKeepFlight(Player player) {
        String playerKey = this.plugin.getConfigManager().getPlayerStorageKey(player, "fly");
        return this.flyConfig.getKeepFlight(playerKey);
    }

    public void setKeepFlight(Player player, boolean keep) {
        String playerKey = this.plugin.getConfigManager().getPlayerStorageKey(player, "fly");
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[FlyManager] setKeepFlight for %s (key: %s): requestedKeep=%s", player.getName(), playerKey, keep));
        }
        this.flyConfig.setKeepFlight(playerKey, keep);
        if (keep) {
            this.flyConfig.setFlyEnabled(playerKey, player.getAllowFlight());
            this.flyConfig.setFlySpeed(playerKey, this.getBukkitSpeedPercentage(player.getFlySpeed()));
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[FlyManager] setKeepFlight for %s: Saving current state (enabled=%s, speed=%.1f) as persistence is ON.", player.getName(), player.getAllowFlight(), this.getBukkitSpeedPercentage(player.getFlySpeed())));
            }
        } else {
            this.flyConfig.setFlyEnabled(playerKey, false);
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[FlyManager] setKeepFlight for %s: Cleared saved state as persistence is OFF.", player.getName()));
            }
        }
    }

    public void restorePlayerFlightState(Player player) {
        String playerKey = this.plugin.getConfigManager().getPlayerStorageKey(player, "fly");
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[FlyManager] restorePlayerFlightState for %s (key: %s): Attempting restore.", player.getName(), playerKey));
        }
        if (this.isFlightAllowedByGamemodeStrict(player)) {
            player.setAllowFlight(true);
            if (this.plugin.getFeatureToggleManager().isFeatureEnabled(player, "fly_speed_control")) {
                this.applyPlayerFlySpeed(player, this.flyConfig.getFlySpeed(playerKey));
            } else {
                player.setFlySpeed(0.1f);
            }
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[FlyManager] restorePlayerFlightState for %s: Gamemode is Creative/Spectator. Flight ALLOWED.", player.getName()));
            }
            return;
        }
        if (!this.plugin.getFeatureToggleManager().isFeatureEnabled(player, "fly_persistence")) {
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[FlyManager] restorePlayerFlightState for %s: Fly persistence feature DISABLED for player.", player.getName()));
            }
            return;
        }
        if (!this.flyConfig.getKeepFlight(playerKey)) {
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[FlyManager] restorePlayerFlightState for %s: Keep flight is OFF in config for player.", player.getName()));
            }
            return;
        }
        boolean shouldBeFlying = this.flyConfig.getFlyEnabled(playerKey);
        double savedSpeed = this.flyConfig.getFlySpeed(playerKey);
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[FlyManager] restorePlayerFlightState for %s: Saved state: enabled=%s, speed=%.1f", player.getName(), shouldBeFlying, savedSpeed));
        }
        if (shouldBeFlying && this.isFlightAllowedByCurrentGamemode(player, true)) {
            player.setAllowFlight(true);
            player.setFlying(true);
            this.applyPlayerFlySpeed(player, savedSpeed);
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[FlyManager] restorePlayerFlightState for %s: Flight restored (enabled=true).", player.getName()));
            }
        } else {
            player.setAllowFlight(false);
            player.setFlying(false);
            player.setFlySpeed(0.1f);
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[FlyManager] restorePlayerFlightState for %s: Flight not restored (saved disabled or gamemode issue).", player.getName()));
            }
        }
    }

    public boolean isFlightAllowedByGamemodeStrict(Player player) {
        GameMode gm = player.getGameMode();
        return gm == GameMode.CREATIVE || gm == GameMode.SPECTATOR;
    }

    public boolean isFlightAllowedByCurrentGamemode(Player player, boolean attemptingToEnable) {
        GameMode gm = player.getGameMode();
        if (gm == GameMode.CREATIVE || gm == GameMode.SPECTATOR) {
            return true;
        }
        return attemptingToEnable && this.plugin.getConfigManager().isAllowSurvivalFly() && gm == GameMode.SURVIVAL;
    }

    public double getBukkitSpeedPercentage(float bukkitSpeed) {
        return (double)(bukkitSpeed / 0.1f) * 100.0;
    }
}

