/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.fly;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.modules.fly.FlyManager;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;

public class FlyListener
implements Listener {
    private final Sundries plugin;
    private final FlyManager flyManager;

    public FlyListener(Sundries plugin) {
        this.plugin = plugin;
        this.flyManager = plugin.getFlyManager();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.plugin.getConfigManager().isPluginEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[FlyListener] Player %s joined. Attempting to restore flight state.", player.getName()));
        }
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.flyManager.restorePlayerFlightState(player), 1L);
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (!this.plugin.getConfigManager().isPluginEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[FlyListener] Player %s respawned. Attempting to restore flight state.", player.getName()));
            }
            this.flyManager.restorePlayerFlightState(player);
        }, 1L);
    }

    @EventHandler
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        if (!this.plugin.getConfigManager().isPluginEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[FlyListener] Player %s changed world. Attempting to restore flight state.", player.getName()));
        }
        this.flyManager.restorePlayerFlightState(player);
    }

    @EventHandler
    public void onPlayerGameModeChange(PlayerGameModeChangeEvent event) {
        if (!this.plugin.getConfigManager().isPluginEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        GameMode newGameMode = event.getNewGameMode();
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[FlyListener] Player %s changed gamemode to %s.", player.getName(), newGameMode.name()));
        }
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            this.flyManager.restorePlayerFlightState(player);
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[FlyListener] Player %s: Flight state restored after gamemode change.", player.getName()));
            }
        }, 1L);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (!this.plugin.getConfigManager().isPluginEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        String playerKey = this.plugin.getConfigManager().getPlayerStorageKey(player, "fly");
        if (this.flyManager.getKeepFlight(player)) {
            this.plugin.getFlyConfig().setFlyEnabled(playerKey, player.getAllowFlight());
            this.plugin.getFlyConfig().setFlySpeed(playerKey, this.flyManager.getBukkitSpeedPercentage(player.getFlySpeed()));
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[FlyListener] Player %s: Saved flight state (allow=%s, speed=%.1f) on quit.", player.getName(), player.getAllowFlight(), this.flyManager.getBukkitSpeedPercentage(player.getFlySpeed())));
            }
        } else if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[FlyListener] Player %s: Keep flight is OFF, not saving state on quit.", player.getName()));
        }
    }
}

