/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.fly;

import ethertaco.sundries.Sundries;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class FlyConfig {
    private final Sundries plugin;
    private File flyConfigFile;
    private FileConfiguration flyConfig;

    public FlyConfig(Sundries plugin) {
        this.plugin = plugin;
        this.setupFlyConfig();
    }

    private void setupFlyConfig() {
        File modulesFolder = new File(this.plugin.getDataFolder(), "modules");
        if (!modulesFolder.exists()) {
            modulesFolder.mkdirs();
        }
        this.flyConfigFile = new File(modulesFolder, "fly.yml");
        if (!this.flyConfigFile.exists()) {
            this.plugin.saveResource("modules/fly.yml", false);
        }
        this.flyConfig = YamlConfiguration.loadConfiguration((File)this.flyConfigFile);
    }

    public void reloadConfig() {
        this.flyConfig = YamlConfiguration.loadConfiguration((File)this.flyConfigFile);
        this.plugin.getLogger().info("modules/fly.yml reloaded.");
    }

    public void saveConfig() {
        try {
            this.flyConfig.save(this.flyConfigFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save modules/fly.yml: " + e.getMessage());
        }
    }

    private ConfigurationSection getPlayerSection(String playerKey) {
        ConfigurationSection section = this.flyConfig.getConfigurationSection("players." + playerKey);
        if (section == null) {
            section = this.flyConfig.createSection("players." + playerKey);
        }
        return section;
    }

    public boolean getFlyEnabled(String playerKey) {
        return this.getPlayerSection(playerKey).getBoolean("enabled", false);
    }

    public void setFlyEnabled(String playerKey, boolean enabled) {
        this.getPlayerSection(playerKey).set("enabled", (Object)enabled);
        this.saveConfig();
    }

    public double getFlySpeed(String playerKey) {
        return this.getPlayerSection(playerKey).getDouble("speed", 100.0);
    }

    public void setFlySpeed(String playerKey, double speedPercentage) {
        this.getPlayerSection(playerKey).set("speed", (Object)speedPercentage);
        this.saveConfig();
    }

    public boolean getKeepFlight(String playerKey) {
        return this.getPlayerSection(playerKey).getBoolean("keep", false);
    }

    public void setKeepFlight(String playerKey, boolean keep) {
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[FlyConfig] Setting keep flight for key '%s' to %s.", playerKey, keep));
        }
        this.getPlayerSection(playerKey).set("keep", (Object)keep);
        this.saveConfig();
    }

    public boolean hasPlayerData(String playerKey) {
        return this.flyConfig.contains("players." + playerKey);
    }

    public void clearAllPlayerData() {
        this.flyConfig.set("players", null);
        this.saveConfig();
        this.plugin.getLogger().info("All player data has been cleared from fly.yml.");
    }
}

