/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.fly;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.commands.AbstractCommand;
import ethertaco.sundries.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FlyCommand
extends AbstractCommand {
    public FlyCommand(Sundries plugin) {
        super(plugin, "fly", "sundries.command.fly");
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        Player targetPlayer = null;
        String action = null;
        if (args.length == 0) {
            if (!this.isPlayer(sender)) {
                return true;
            }
            targetPlayer = (Player)sender;
            if (!sender.hasPermission("sundries.command.fly.self")) {
                MessageUtils.sendError(sender, "command.no_permission", "permission", "sundries.command.fly.self");
                return true;
            }
            action = "on";
        } else if (args.length == 1) {
            String arg0 = args[0].toLowerCase();
            if (arg0.equals("on") || arg0.equals("off") || arg0.equals("keep")) {
                if (!this.isPlayer(sender)) {
                    return true;
                }
                targetPlayer = (Player)sender;
                if (!sender.hasPermission("sundries.command.fly.self")) {
                    MessageUtils.sendError(sender, "command.no_permission", "permission", "sundries.command.fly.self");
                    return true;
                }
                action = arg0;
            } else {
                if (!sender.hasPermission("sundries.command.fly.others")) {
                    MessageUtils.sendError(sender, "command.no_permission", "permission", "sundries.command.fly.others");
                    return true;
                }
                targetPlayer = Bukkit.getPlayer((String)args[0]);
                if (targetPlayer == null) {
                    MessageUtils.sendError(sender, "command.not_online", "player_name", args[0]);
                    return false;
                }
                action = "on";
            }
        } else if (args.length == 2) {
            if (!sender.hasPermission("sundries.command.fly.others")) {
                MessageUtils.sendError(sender, "command.no_permission", "permission", "sundries.command.fly.others");
                return true;
            }
            targetPlayer = Bukkit.getPlayer((String)args[0]);
            if (targetPlayer == null) {
                MessageUtils.sendError(sender, "command.not_online", "player_name", args[0]);
                return false;
            }
            action = args[1].toLowerCase();
        } else {
            this.sendUsage(sender, "/su fly [player_name] [on|off|keep]");
            return false;
        }
        if (targetPlayer == null) {
            MessageUtils.sendError(sender, "command.player_not_found", "player_name", args.length > 0 ? args[0] : "");
            return false;
        }
        String senderName = sender instanceof Player ? sender.getName() : "Console";
        switch (action) {
            case "on": {
                if (!this.plugin.getFlyManager().isFlightAllowedByCurrentGamemode(targetPlayer, true)) {
                    MessageUtils.sendWarning(sender, "command.fly.gamemode_not_allowed_for_feature", "player_name", targetPlayer.getName());
                    return true;
                }
                if (targetPlayer.getAllowFlight()) {
                    MessageUtils.sendInfo(sender, "command.fly.already_flying", "player_name", targetPlayer.getName());
                    break;
                }
                this.plugin.getFlyManager().setPlayerFlight(targetPlayer, true);
                MessageUtils.sendSuccess(sender, "command.fly.enabled", "player_name", targetPlayer.getName());
                if (sender == targetPlayer) break;
                MessageUtils.sendMessage((Audience)targetPlayer, "command.fly.enabled_by_other", "sender_name", senderName);
                break;
            }
            case "off": {
                if (!targetPlayer.getAllowFlight()) {
                    MessageUtils.sendInfo(sender, "command.fly.not_flying", "player_name", targetPlayer.getName());
                    break;
                }
                this.plugin.getFlyManager().setPlayerFlight(targetPlayer, false);
                MessageUtils.sendSuccess(sender, "command.fly.disabled", "player_name", targetPlayer.getName());
                if (sender == targetPlayer) break;
                MessageUtils.sendMessage((Audience)targetPlayer, "command.fly.disabled_by_other", "sender_name", senderName);
                break;
            }
            case "keep": {
                if (!this.plugin.getFeatureToggleManager().isFeatureEnabled(targetPlayer, "fly_persistence")) {
                    MessageUtils.sendError(sender, "command.fly.feature_disabled", new Object[0]);
                    return true;
                }
                boolean currentKeepState = this.plugin.getFlyManager().getKeepFlight(targetPlayer);
                this.plugin.getFlyManager().setKeepFlight(targetPlayer, !currentKeepState);
                if (!currentKeepState) {
                    MessageUtils.sendSuccess(sender, "command.fly.keep_enabled", "player_name", targetPlayer.getName());
                    if (sender == targetPlayer) break;
                    MessageUtils.sendMessage((Audience)targetPlayer, "command.fly.keep_enabled_by_other", "sender_name", senderName);
                    break;
                }
                MessageUtils.sendSuccess(sender, "command.fly.keep_disabled", "player_name", targetPlayer.getName());
                if (sender == targetPlayer) break;
                MessageUtils.sendMessage((Audience)targetPlayer, "command.fly.keep_disabled_by_other", "sender_name", senderName);
                break;
            }
            default: {
                this.sendUsage(sender, "/su fly [player_name] [on|off|keep]");
                return false;
            }
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        ArrayList completions = new ArrayList();
        List<String> actions = Arrays.asList("on", "off", "keep");
        if (args.length == 1) {
            if (sender.hasPermission("sundries.command.fly.self")) {
                completions.addAll(actions.stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList()));
            }
            if (sender.hasPermission("sundries.command.fly.others")) {
                completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList()));
            }
        } else if (args.length == 2 && sender.hasPermission("sundries.command.fly.others")) {
            completions.addAll(actions.stream().filter(s -> s.startsWith(args[1].toLowerCase())).collect(Collectors.toList()));
        }
        return completions.stream().distinct().collect(Collectors.toList());
    }
}

