/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.core;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.commands.AbstractCommand;
import ethertaco.sundries.utils.ConfigUpdater;
import ethertaco.sundries.utils.MessageUtils;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UpdateConfigCommand
extends AbstractCommand {
    public UpdateConfigCommand(Sundries plugin) {
        super(plugin, "updateconfig", "sundries.admin.updateconfig");
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        String configVersion;
        if (!this.checkPermission(sender)) {
            return true;
        }
        String pluginVersion = this.plugin.getDescription().getVersion();
        if (pluginVersion.equals(configVersion = this.plugin.getConfigManager().getConfigVersion())) {
            MessageUtils.sendInfo(sender, "command.updateconfig.already_latest", "version", pluginVersion);
            return true;
        }
        if (!(sender instanceof Player)) {
            MessageUtils.sendInfo(sender, "command.updateconfig.console_auto_update", new Object[0]);
            try {
                new ConfigUpdater(this.plugin).update();
                this.plugin.reloadPluginLogic();
            }
            catch (Exception e) {
                MessageUtils.sendError(sender, "command.updateconfig.update_failed", new Object[0]);
                this.plugin.getLogger().severe("Config update failed: " + e.getMessage());
            }
            return true;
        }
        Player player = (Player)sender;
        this.plugin.getConfirmations().put(player.getUniqueId(), s -> {
            try {
                MessageUtils.sendInfo(s, "command.updateconfig.starting_update", new Object[0]);
                new ConfigUpdater(this.plugin).update();
                MessageUtils.sendSuccess(s, "command.updateconfig.update_success", new Object[0]);
                this.plugin.reloadPluginLogic();
                MessageUtils.sendSuccess(s, "command.updateconfig.reload_success", new Object[0]);
            }
            catch (Exception e) {
                MessageUtils.sendError(s, "command.updateconfig.update_failed", new Object[0]);
                this.plugin.getLogger().severe("Config update failed: " + e.getMessage());
            }
        });
        MessageUtils.sendWarning(sender, "command.updateconfig.confirmation_required", "old_version", configVersion, "new_version", pluginVersion);
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        return Collections.emptyList();
    }
}

