/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.core;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.commands.AbstractCommand;
import ethertaco.sundries.managers.FeatureToggleManager;
import ethertaco.sundries.utils.MessageUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class StatusCommand
extends AbstractCommand {
    public StatusCommand(Sundries plugin) {
        super(plugin, "status", "sundries.admin.status");
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        Player targetPlayer = null;
        if (args.length == 0) {
            if (!sender.hasPermission(this.permission)) {
                MessageUtils.sendError(sender, "command.no_permission", "permission", this.permission);
                return true;
            }
            if (!(sender instanceof Player)) {
                MessageUtils.sendInfo(sender, "command.status.console_player_status_hint", new Object[0]);
                return true;
            }
            targetPlayer = (Player)sender;
        } else if (args.length == 1) {
            if (!sender.hasPermission("sundries.admin.status.others")) {
                MessageUtils.sendError(sender, "command.no_permission", "permission", "sundries.admin.status.others");
                return true;
            }
            targetPlayer = Bukkit.getPlayer((String)args[0]);
            if (targetPlayer == null) {
                MessageUtils.sendError(sender, "command.not_online", "player_name", args[0]);
                return false;
            }
        } else {
            this.sendUsage(sender, "/su status [player_name]");
            return false;
        }
        MessageUtils.sendInfo(sender, "command.status.header", new Object[0]);
        String pluginStatusKey = this.plugin.getConfigManager().isPluginEnabled() ? "status.enabled" : "status.disabled";
        MessageUtils.sendInfo(sender, "command.status.overall_status", "status_text", this.plugin.getLangManager().getMessage(pluginStatusKey));
        MessageUtils.sendInfo(sender, "command.status.default_features_header", new Object[0]);
        for (String feature : FeatureToggleManager.TOGGLEABLE_FEATURES) {
            boolean defaultStatus = this.plugin.getConfigManager().getDefaultFeatureStatus(feature);
            String featureStatusKey = defaultStatus ? "status.enabled" : "status.disabled";
            MessageUtils.sendInfo(sender, "command.status.feature_status", "feature_id", feature, "status_text", this.plugin.getLangManager().getMessage(featureStatusKey));
        }
        MessageUtils.sendInfo(sender, "command.status.your_features_header", "player_name", targetPlayer.getName());
        for (String feature : FeatureToggleManager.TOGGLEABLE_FEATURES) {
            boolean playerStatus = this.plugin.getFeatureToggleManager().isFeatureEnabled(targetPlayer, feature);
            String sourceKey = "";
            Boolean specificSetting = this.plugin.getFeatureConfig().getPlayerFeatureStatus(targetPlayer.getName(), feature);
            sourceKey = specificSetting != null ? "command.status.player_source_specific" : (targetPlayer.isOp() ? "command.status.player_source_op_default" : "command.status.player_source_global_default");
            String featureStatusKey = playerStatus ? "status.enabled" : "status.disabled";
            MessageUtils.sendInfo(sender, "command.status.feature_status", "feature_id", feature, "status_text", this.plugin.getLangManager().getMessage(featureStatusKey) + " " + this.plugin.getLangManager().getMessage(sourceKey));
        }
        MessageUtils.sendInfo(sender, "command.status.footer", new Object[0]);
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (args.length == 1 && sender.hasPermission("sundries.admin.status.others")) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

