/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.core;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.commands.AbstractCommand;
import ethertaco.sundries.managers.FeatureToggleManager;
import ethertaco.sundries.utils.MessageUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PermCommand
extends AbstractCommand {
    public PermCommand(Sundries plugin) {
        super(plugin, "perm", "sundries.admin.perm");
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!this.checkPermission(sender)) {
            return true;
        }
        if (args.length != 3) {
            this.sendUsage(sender, "/su perm <feature_id> <player_name> <on|off|default>");
            return false;
        }
        String featureId = args[0].toLowerCase();
        String targetPlayerName = args[1];
        String statusArg = args[2].toLowerCase();
        if (!FeatureToggleManager.TOGGLEABLE_FEATURES.contains(featureId)) {
            MessageUtils.sendError(sender, "command.function.unknown_feature", "feature_id", featureId);
            MessageUtils.sendInfo(sender, "command.function.available_features", "features_list", String.join((CharSequence)", ", FeatureToggleManager.TOGGLEABLE_FEATURES));
            return false;
        }
        OfflinePlayer targetOfflinePlayer = Bukkit.getOfflinePlayer((String)targetPlayerName);
        if (!targetOfflinePlayer.hasPlayedBefore() && !targetOfflinePlayer.isOnline()) {
            MessageUtils.sendError(sender, "command.player_not_found", "player_name", targetPlayerName);
            return false;
        }
        String playerKey = this.plugin.getConfigManager().getOfflinePlayerStorageKey(targetOfflinePlayer, "features");
        if (statusArg.equals("default")) {
            this.plugin.getFeatureToggleManager().removePlayerFeatureStatus(playerKey, featureId);
            this.plugin.getFeatureConfig().reloadConfig();
            MessageUtils.sendSuccess(sender, "command.perm.remove_success", "player_name", targetOfflinePlayer.getName(), "feature_id", featureId);
        } else {
            boolean enable;
            if (statusArg.equals("on")) {
                enable = true;
            } else if (statusArg.equals("off")) {
                enable = false;
            } else {
                this.sendUsage(sender, "/su perm <feature_id> <player_name> <on|off|default>");
                MessageUtils.sendError(sender, "command.invalid_status", new Object[0]);
                return false;
            }
            this.plugin.getFeatureToggleManager().setPlayerFeatureStatus(playerKey, featureId, enable);
            this.plugin.getFeatureConfig().reloadConfig();
            String statusKey = enable ? "status.enabled" : "status.disabled";
            MessageUtils.sendSuccess(sender, "command.perm.set_success", "player_name", targetOfflinePlayer.getName(), "feature_id", featureId, "status_text", this.plugin.getLangManager().getMessage(statusKey));
        }
        Player onlineTargetPlayer = targetOfflinePlayer.getPlayer();
        if (onlineTargetPlayer != null && (featureId.equals("fly_persistence") || featureId.equals("fly_speed_control"))) {
            this.plugin.getFlyManager().restorePlayerFlightState(onlineTargetPlayer);
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (!sender.hasPermission(this.permission)) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return FeatureToggleManager.TOGGLEABLE_FEATURES.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 3) {
            return Arrays.asList("on", "off", "default").stream().filter(s -> s.startsWith(args[2].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

