/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.core;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.commands.AbstractCommand;
import ethertaco.sundries.utils.MessageUtils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;

public class LangCommand
extends AbstractCommand {
    public LangCommand(Sundries plugin) {
        super(plugin, "lang", "sundries.admin.lang");
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!this.checkPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            MessageUtils.sendInfo(sender, "command.lang.current", "lang_code", this.plugin.getConfigManager().getLanguage());
            MessageUtils.sendUsage(sender, "/su lang <locale_code>");
            return true;
        }
        if (args.length == 1) {
            String requestedLocale = args[0];
            List<String> availableLocales = this.plugin.getLangManager().getAvailableLocales();
            String foundLocale = availableLocales.stream().filter(s -> s.equalsIgnoreCase(requestedLocale)).findFirst().orElse(null);
            if (foundLocale == null) {
                MessageUtils.sendError(sender, "command.lang.not_found", "lang_code", requestedLocale, "available_locales", String.join((CharSequence)", ", availableLocales));
                return false;
            }
            if (this.plugin.getConfigManager().getLanguage().equalsIgnoreCase(foundLocale)) {
                MessageUtils.sendInfo(sender, "command.lang.already_set", "lang_code", foundLocale);
                return true;
            }
            this.plugin.getConfigManager().setLanguage(foundLocale);
            this.plugin.getLangManager().loadLocale(foundLocale);
            MessageUtils.sendSuccess(sender, "command.lang.set_success", "lang_code", foundLocale);
            return true;
        }
        this.sendUsage(sender, "/su lang <locale_code>");
        return false;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (!sender.hasPermission(this.permission)) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return this.plugin.getLangManager().getAvailableLocales().stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

