/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.core;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.commands.AbstractCommand;
import ethertaco.sundries.managers.FeatureToggleManager;
import ethertaco.sundries.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;

public class FunctionCommand
extends AbstractCommand {
    public FunctionCommand(Sundries plugin) {
        super(plugin, "function", "sundries.admin.function");
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        String statusKey;
        boolean enable;
        if (!this.checkPermission(sender)) {
            return true;
        }
        if (args.length != 2) {
            this.sendUsage(sender, "/su function <feature|all> <on|off>");
            return false;
        }
        String featureId = args[0].toLowerCase();
        String statusArg = args[1].toLowerCase();
        if (statusArg.equals("on")) {
            enable = true;
        } else if (statusArg.equals("off")) {
            enable = false;
        } else {
            this.sendUsage(sender, "/su function <feature|all> <on|off>");
            MessageUtils.sendError(sender, "command.invalid_status", new Object[0]);
            return false;
        }
        String string = statusKey = enable ? "status.enabled" : "status.disabled";
        if (featureId.equals("all")) {
            for (String feature : FeatureToggleManager.TOGGLEABLE_FEATURES) {
                this.plugin.getFeatureToggleManager().setDefaultGlobalFeatureStatus(feature, enable);
            }
            MessageUtils.sendSuccess(sender, "command.function.set_all_success", "status_text", this.plugin.getLangManager().getMessage(statusKey));
        } else if (FeatureToggleManager.TOGGLEABLE_FEATURES.contains(featureId)) {
            this.plugin.getFeatureToggleManager().setDefaultGlobalFeatureStatus(featureId, enable);
            MessageUtils.sendSuccess(sender, "command.function.set_feature_success", "feature_id", featureId, "status_text", this.plugin.getLangManager().getMessage(statusKey));
        } else {
            MessageUtils.sendError(sender, "command.function.unknown_feature", "feature_id", featureId);
            MessageUtils.sendInfo(sender, "command.function.available_features", "features_list", String.join((CharSequence)", ", FeatureToggleManager.TOGGLEABLE_FEATURES));
            return false;
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (!sender.hasPermission(this.permission)) {
            return Collections.emptyList();
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("all");
            completions.addAll(FeatureToggleManager.TOGGLEABLE_FEATURES);
            return completions.stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            return Arrays.asList("on", "off").stream().filter(s -> s.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

