/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.autocrafter;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.modules.autocrafter.AutoCrafterConfig;
import ethertaco.sundries.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.Dropper;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Item;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class AutoCrafterManager {
    private final Sundries plugin;
    private final AutoCrafterConfig autoCrafterConfig;
    private final NamespacedKey AUTO_CRAFTER_ITEM_KEY;

    public AutoCrafterManager(Sundries plugin, AutoCrafterConfig autoCrafterConfig) {
        this.plugin = plugin;
        this.autoCrafterConfig = autoCrafterConfig;
        this.AUTO_CRAFTER_ITEM_KEY = new NamespacedKey((Plugin)plugin, "autocrafter_item");
    }

    private boolean itemsMatch(ItemStack required, ItemStack provided) {
        if (required == null || required.getType() == Material.AIR) {
            return provided == null || provided.getType() == Material.AIR;
        }
        if (provided == null || provided.getType() == Material.AIR) {
            return false;
        }
        return required.getType() == provided.getType();
    }

    /*
     * Could not resolve type clashes
     */
    public boolean craft(Dropper dropper) {
        if (!this.plugin.getConfigManager().isPluginEnabled() || !this.plugin.getFeatureToggleManager().getDefaultGlobalFeatureStatus("autocrafter")) {
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine("[AutoCrafterManager] Crafting disabled globally or plugin disabled.");
            }
            return false;
        }
        Location loc = dropper.getLocation();
        Set<Integer> lockedSlots = this.autoCrafterConfig.getLockedSlots(loc);
        Inventory dummyInventory = Bukkit.createInventory(null, (InventoryType)InventoryType.WORKBENCH, (String)"Crafting");
        Object[] dropperContents = dropper.getInventory().getContents();
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[AutoCrafterManager] Attempting craft at %s. Dropper contents: %s. Locked slots: %s", loc, Arrays.toString(dropperContents), lockedSlots));
        }
        for (int i = 0; i < 9; ++i) {
            if (i >= dropperContents.length) continue;
            dummyInventory.setItem(i, dropperContents[i] != null ? dropperContents[i].clone() : null);
        }
        CraftingInventory craftingInventory = (CraftingInventory)dummyInventory;
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine("[AutoCrafterManager] Crafting matrix for matching (before recipe search):");
            ItemStack[] matrix = craftingInventory.getMatrix();
            for (int j = 0; j < matrix.length; ++j) {
                ItemStack item = matrix[j];
                String itemInfo = item != null ? item.getType().name() + " x" + item.getAmount() : "null";
                this.plugin.getLogger().fine(String.format("  Slot %d: %s", j, itemInfo));
                if (item == null || !item.hasItemMeta()) continue;
                this.plugin.getLogger().fine("    Item NBT keys: " + item.getItemMeta().getPersistentDataContainer().getKeys());
            }
        }
        Recipe foundRecipe = null;
        Iterator recipeIterator = Bukkit.recipeIterator();
        while (recipeIterator.hasNext()) {
            Recipe recipe = (Recipe)recipeIterator.next();
            if (recipe instanceof ShapedRecipe) {
                ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                if (this.plugin.getConfigManager().getDebugMode()) {
                    this.plugin.getLogger().fine("[AutoCrafterManager] Checking ShapedRecipe: " + shapedRecipe.getKey().getKey());
                }
                String[] recipeShape = shapedRecipe.getShape();
                Map ingredientMap = shapedRecipe.getIngredientMap();
                ItemStack[][] rawIdealMatrix = this.rawMatrixFromRecipeShape(recipeShape, ingredientMap);
                ItemStack[][] currentGrid = new ItemStack[3][3];
                for (int r = 0; r < 3; ++r) {
                    for (int c = 0; c < 3; ++c) {
                        currentGrid[r][c] = craftingInventory.getItem(r * 3 + c);
                    }
                }
                boolean currentShapedRecipeMatches = false;
                for (int rot = 0; rot < 4; ++rot) {
                    ItemStack[][] rotatedIdealMatrix = this.rotateMatrix(rawIdealMatrix, rot);
                    ItemStack[][] flippedRotatedIdealMatrix = this.flipMatrixHorizontal(rotatedIdealMatrix);
                    int effectiveRecipeHeight = recipeShape.length;
                    int effectiveRecipeWidth = effectiveRecipeHeight > 0 ? recipeShape[0].length() : 0;
                    for (int startRow = 0; startRow <= 3 - effectiveRecipeHeight; ++startRow) {
                        for (int startCol = 0; startCol <= 3 - effectiveRecipeWidth; ++startCol) {
                            if (this.checkMatrixMatch(rotatedIdealMatrix, currentGrid, startRow, startCol, effectiveRecipeHeight, effectiveRecipeWidth)) {
                                currentShapedRecipeMatches = true;
                                break;
                            }
                            if (!this.checkMatrixMatch(flippedRotatedIdealMatrix, currentGrid, startRow, startCol, effectiveRecipeHeight, effectiveRecipeWidth)) continue;
                            currentShapedRecipeMatches = true;
                            break;
                        }
                        if (currentShapedRecipeMatches) break;
                    }
                    if (currentShapedRecipeMatches) break;
                }
                if (!currentShapedRecipeMatches) continue;
                foundRecipe = recipe;
                if (!this.plugin.getConfigManager().getDebugMode()) break;
                this.plugin.getLogger().fine("[AutoCrafterManager] ShapedRecipe matched: " + shapedRecipe.getKey().getKey());
                break;
            }
            if (!(recipe instanceof ShapelessRecipe)) continue;
            ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine("[AutoCrafterManager] Checking ShapelessRecipe: " + shapelessRecipe.getKey().getKey());
            }
            ArrayList requiredIngredients = new ArrayList(shapelessRecipe.getIngredientList());
            ArrayList<ItemStack> providedIngredients = new ArrayList<ItemStack>();
            for (ItemStack[] item : craftingInventory.getMatrix()) {
                if (item == null || item.getType() == Material.AIR) continue;
                providedIngredients.add(item.clone());
            }
            boolean allMatch = true;
            if (providedIngredients.size() != requiredIngredients.size()) {
                allMatch = false;
            } else {
                ArrayList tempProvided = new ArrayList(providedIngredients);
                for (ItemStack requiredItem : requiredIngredients) {
                    boolean found = false;
                    for (int i = 0; i < tempProvided.size(); ++i) {
                        if (!this.itemsMatch(requiredItem, (ItemStack)tempProvided.get(i))) continue;
                        tempProvided.remove(i);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    allMatch = false;
                    break;
                }
                if (!tempProvided.isEmpty()) {
                    allMatch = false;
                }
            }
            if (!allMatch) continue;
            foundRecipe = recipe;
            if (!this.plugin.getConfigManager().getDebugMode()) break;
            this.plugin.getLogger().fine("[AutoCrafterManager] ShapelessRecipe matched: " + shapelessRecipe.getKey().getKey());
            break;
        }
        if (foundRecipe == null || foundRecipe.getResult() == null || foundRecipe.getResult().getType() == Material.AIR) {
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine("[AutoCrafterManager] No recipe found for dropper at " + loc);
            }
            return false;
        }
        ItemStack result = foundRecipe.getResult().clone();
        ArrayList<ItemStack> remainingItems = new ArrayList<ItemStack>();
        ItemStack[] currentMatrix = craftingInventory.getMatrix();
        for (int i = 0; i < currentMatrix.length; ++i) {
            Material remainingMaterial;
            ItemStack ingredient = currentMatrix[i];
            if (ingredient == null || ingredient.getType() == Material.AIR || (remainingMaterial = ingredient.getType().getCraftingRemainingItem()) == null || remainingMaterial == Material.AIR) continue;
            remainingItems.add(new ItemStack(remainingMaterial));
        }
        if (foundRecipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)foundRecipe;
            String[] recipeShape = shapedRecipe.getShape();
            Map ingredientMap = shapedRecipe.getIngredientMap();
            ArrayList<ItemStack> neededFromRecipe = new ArrayList<ItemStack>();
            for (String row : recipeShape) {
                for (char c : row.toCharArray()) {
                    ItemStack needed = (ItemStack)ingredientMap.get(Character.valueOf(c));
                    if (needed == null || needed.getType() == Material.AIR) continue;
                    neededFromRecipe.add(needed.clone());
                }
            }
            block14: for (int i = 0; i < 9; ++i) {
                Object dropperItem;
                if (lockedSlots.contains(i) || (dropperItem = dropperContents[i]) == null || dropperItem.getType() == Material.AIR) continue;
                boolean consumed = false;
                for (int j = 0; j < neededFromRecipe.size(); ++j) {
                    if (!this.itemsMatch((ItemStack)neededFromRecipe.get(j), (ItemStack)dropperItem)) continue;
                    dropperItem.subtract(1);
                    if (dropperItem.getAmount() <= 0) {
                        dropperContents[i] = null;
                    }
                    ((ItemStack)neededFromRecipe.get(j)).subtract(1);
                    if (((ItemStack)neededFromRecipe.get(j)).getAmount() <= 0) {
                        neededFromRecipe.remove(j);
                    }
                    consumed = true;
                    continue block14;
                }
            }
        } else if (foundRecipe instanceof ShapelessRecipe) {
            ShapelessRecipe shapelessRecipe = (ShapelessRecipe)foundRecipe;
            ArrayList neededFromRecipe = new ArrayList(shapelessRecipe.getIngredientList());
            block16: for (int i = 0; i < 9; ++i) {
                Object dropperItem;
                if (lockedSlots.contains(i) || (dropperItem = dropperContents[i]) == null || dropperItem.getType() == Material.AIR) continue;
                boolean consumed = false;
                for (int j = 0; j < neededFromRecipe.size(); ++j) {
                    if (!this.itemsMatch((ItemStack)neededFromRecipe.get(j), (ItemStack)dropperItem)) continue;
                    dropperItem.subtract(1);
                    if (dropperItem.getAmount() <= 0) {
                        dropperContents[i] = null;
                    }
                    ((ItemStack)neededFromRecipe.get(j)).subtract(1);
                    if (((ItemStack)neededFromRecipe.get(j)).getAmount() <= 0) {
                        neededFromRecipe.remove(j);
                    }
                    consumed = true;
                    continue block16;
                }
            }
        }
        dropper.getInventory().setContents((ItemStack[])dropperContents);
        ArrayList<ItemStack> itemsToOutput = new ArrayList<ItemStack>();
        itemsToOutput.add(result);
        itemsToOutput.addAll(remainingItems);
        for (ItemStack item : itemsToOutput) {
            HashMap overflow;
            if (item == null || item.getType() == Material.AIR || (overflow = dropper.getInventory().addItem(new ItemStack[]{item})).isEmpty()) continue;
            for (ItemStack overflowItem : overflow.values()) {
                this.dropItemFromDropperMouth(dropper, overflowItem);
                if (!this.plugin.getConfigManager().getDebugMode()) continue;
                this.plugin.getLogger().fine(String.format("[AutoCrafterManager] Dropper at %s overflowed, dropping %s.", loc, overflowItem));
            }
        }
        dropper.update();
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine("[AutoCrafterManager] Successfully crafted item: " + result.getType() + " at " + loc);
        }
        return true;
    }

    private void dropItemFromDropperMouth(Dropper dropper, ItemStack item) {
        Location dropLocation = dropper.getLocation().add(0.5, 0.5, 0.5);
        Directional directional = (Directional)dropper.getBlockData();
        switch (directional.getFacing()) {
            case DOWN: {
                dropLocation.subtract(0.0, 0.6, 0.0);
                break;
            }
            case UP: {
                dropLocation.add(0.0, 0.6, 0.0);
                break;
            }
            case NORTH: {
                dropLocation.subtract(0.0, 0.0, 0.6);
                break;
            }
            case SOUTH: {
                dropLocation.add(0.0, 0.0, 0.6);
                break;
            }
            case WEST: {
                dropLocation.subtract(0.6, 0.0, 0.0);
                break;
            }
            case EAST: {
                dropLocation.add(0.6, 0.0, 0.0);
                break;
            }
        }
        Item droppedItem = dropper.getWorld().dropItemNaturally(dropLocation, item);
        droppedItem.setVelocity(droppedItem.getVelocity().multiply(0.1));
    }

    public ItemStack getAutoCrafterItem() {
        ItemStack dropperItem = new ItemStack(Material.DROPPER);
        ItemMeta meta = dropperItem.getItemMeta();
        meta.displayName(MessageUtils.miniMessage.deserialize((Object)this.plugin.getLangManager().getMessage("autocrafter.item_name")));
        meta.lore(List.of(MessageUtils.miniMessage.deserialize((Object)this.plugin.getLangManager().getMessage("autocrafter.item_lore_line1")), MessageUtils.miniMessage.deserialize((Object)this.plugin.getLangManager().getMessage("autocrafter.item_lore_line2"))));
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.set(this.AUTO_CRAFTER_ITEM_KEY, PersistentDataType.BYTE, (Object)1);
        dropperItem.setItemMeta(meta);
        return dropperItem;
    }

    public boolean isAutoCrafterItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        return item.getItemMeta().getPersistentDataContainer().has(this.AUTO_CRAFTER_ITEM_KEY, PersistentDataType.BYTE);
    }

    public boolean isAutoCrafterBlock(Block block) {
        if (block == null || block.getType() != Material.DROPPER) {
            return false;
        }
        return this.autoCrafterConfig.isAutoCrafter(block.getLocation());
    }

    public Set<Integer> getLockedSlots(Location location) {
        return this.autoCrafterConfig.getLockedSlots(location);
    }

    public void setLockedSlots(Location location, Set<Integer> lockedSlots) {
        this.autoCrafterConfig.setLockedSlots(location, lockedSlots);
    }

    public void registerAutoCrafter(Location location) {
        this.autoCrafterConfig.addAutoCrafter(location);
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine("Registered auto crafter at " + location);
        }
    }

    public void unregisterAutoCrafter(Location location) {
        this.autoCrafterConfig.removeAutoCrafter(location);
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine("Unregistered auto crafter at " + location);
        }
    }

    public void cleanup() {
        this.plugin.getLogger().info("[AutoCrafterManager] Cleanup complete.");
    }

    public void validatePlacedAutoCrafters() {
        this.plugin.getLogger().info("Validating placed auto crafters...");
        HashSet<String> keysToRemove = new HashSet<String>();
        for (String key : this.autoCrafterConfig.getAllAutoCrafterKeys()) {
            Location loc = AutoCrafterConfig.getLocationFromKey(this.plugin, key);
            if (loc != null && loc.isChunkLoaded() && loc.getBlock().getState() instanceof Dropper && loc.getBlock().getType() == Material.DROPPER) continue;
            if (loc != null && loc.isChunkLoaded() && loc.getBlock().getType() != Material.DROPPER) {
                keysToRemove.add(key);
                if (!this.plugin.getConfigManager().getDebugMode()) continue;
                this.plugin.getLogger().fine("Removing invalid auto crafter entry for " + key + ": Block changed or missing.");
                continue;
            }
            if (loc != null) continue;
            keysToRemove.add(key);
            if (!this.plugin.getConfigManager().getDebugMode()) continue;
            this.plugin.getLogger().fine("Removing invalid auto crafter entry for " + key + ": Location invalid (world not loaded or key error).");
        }
        for (String key : keysToRemove) {
            this.autoCrafterConfig.removeAutoCrafter(AutoCrafterConfig.getLocationFromKey(this.plugin, key));
        }
        this.plugin.getLogger().info(String.format("Auto crafter validation complete. Removed %d invalid entries.", keysToRemove.size()));
    }

    private boolean checkMatrixMatch(ItemStack[][] idealRecipeMatrix, ItemStack[][] currentCraftingGrid, int startRow, int startCol, int recipeActualHeight, int recipeActualWidth) {
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                ItemStack provided;
                ItemStack required = null;
                if (r >= startRow && r < startRow + recipeActualHeight && c >= startCol && c < startCol + recipeActualWidth) {
                    required = idealRecipeMatrix[r - startRow][c - startCol];
                }
                if (this.itemsMatch(required, provided = currentCraftingGrid[r][c])) continue;
                return false;
            }
        }
        return true;
    }

    private ItemStack[][] rotateMatrix(ItemStack[][] matrix, int rotations) {
        ItemStack[][] rotated = new ItemStack[3][3];
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                if (rotations % 4 == 0) {
                    rotated[r][c] = matrix[r][c];
                    continue;
                }
                if (rotations % 4 == 1) {
                    rotated[c][2 - r] = matrix[r][c];
                    continue;
                }
                if (rotations % 4 == 2) {
                    rotated[2 - r][2 - c] = matrix[r][c];
                    continue;
                }
                rotated[2 - c][r] = matrix[r][c];
            }
        }
        return rotated;
    }

    private ItemStack[][] flipMatrixHorizontal(ItemStack[][] matrix) {
        ItemStack[][] flipped = new ItemStack[3][3];
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                flipped[r][2 - c] = matrix[r][c];
            }
        }
        return flipped;
    }

    private ItemStack[][] rawMatrixFromRecipeShape(String[] recipeShape, Map<Character, ItemStack> ingredientMap) {
        ItemStack[][] idealMatrix = new ItemStack[3][3];
        for (int r = 0; r < 3; ++r) {
            Arrays.fill(idealMatrix[r], new ItemStack(Material.AIR));
        }
        int recipeHeight = recipeShape.length;
        int recipeWidth = recipeHeight > 0 ? recipeShape[0].length() : 0;
        for (int r = 0; r < recipeHeight; ++r) {
            String row = recipeShape[r];
            for (int c = 0; c < row.length(); ++c) {
                char charInRecipe = row.charAt(c);
                ItemStack requiredIngredient = ingredientMap.get(Character.valueOf(charInRecipe));
                if (r >= 3 || c >= 3) continue;
                idealMatrix[r][c] = requiredIngredient != null ? requiredIngredient.clone() : new ItemStack(Material.AIR);
            }
        }
        return idealMatrix;
    }
}

