/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.autocrafter;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.modules.autocrafter.AutoCrafterGUI;
import ethertaco.sundries.modules.autocrafter.AutoCrafterManager;
import ethertaco.sundries.utils.MessageUtils;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Dropper;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class AutoCrafterListener
implements Listener {
    private final Sundries plugin;
    private final AutoCrafterManager autoCrafterManager;
    private final Map<UUID, AutoCrafterGUI> openedGUIs = new ConcurrentHashMap<UUID, AutoCrafterGUI>();

    public AutoCrafterListener(Sundries plugin) {
        this.plugin = plugin;
        this.autoCrafterManager = plugin.getAutoCrafterManager();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockDispense(BlockDispenseEvent event) {
        if (!this.plugin.getConfigManager().getDefaultFeatureStatus("autocrafter")) {
            return;
        }
        Block block = event.getBlock();
        if (!(block.getState() instanceof Dropper)) {
            return;
        }
        if (this.autoCrafterManager.isAutoCrafterBlock(block)) {
            event.setCancelled(true);
            this.autoCrafterManager.craft((Dropper)block.getState());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!this.plugin.getConfigManager().getDefaultFeatureStatus("autocrafter")) {
            return;
        }
        if (event.getBlockPlaced().getType() != Material.DROPPER) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack itemInHand = event.getItemInHand();
        if (this.autoCrafterManager.isAutoCrafterItem(itemInHand)) {
            if (!this.plugin.getFeatureToggleManager().isFeatureEnabled(player, "autocrafter")) {
                MessageUtils.sendError((CommandSender)player, "autocrafter.feature_disabled", new Object[0]);
                event.setCancelled(true);
                return;
            }
            this.autoCrafterManager.registerAutoCrafter(event.getBlockPlaced().getLocation());
            MessageUtils.sendSuccess((CommandSender)player, "autocrafter.place_success", new Object[0]);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.plugin.getConfigManager().getDefaultFeatureStatus("autocrafter")) {
            return;
        }
        Block brokenBlock = event.getBlock();
        if (brokenBlock.getType() != Material.DROPPER || !this.autoCrafterManager.isAutoCrafterBlock(brokenBlock)) {
            return;
        }
        Player player = event.getPlayer();
        this.openedGUIs.remove(player.getUniqueId());
        if (player.getGameMode() == GameMode.CREATIVE) {
            this.autoCrafterManager.unregisterAutoCrafter(brokenBlock.getLocation());
            MessageUtils.sendInfo((CommandSender)player, "autocrafter.break_success_creative", new Object[0]);
            return;
        }
        event.setDropItems(false);
        this.autoCrafterManager.unregisterAutoCrafter(brokenBlock.getLocation());
        ItemStack customDropper = this.autoCrafterManager.getAutoCrafterItem();
        brokenBlock.getWorld().dropItemNaturally(brokenBlock.getLocation().add(0.5, 0.5, 0.5), customDropper);
        MessageUtils.sendSuccess((CommandSender)player, "autocrafter.break_success", new Object[0]);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.plugin.getConfigManager().getDefaultFeatureStatus("autocrafter")) {
            return;
        }
        if (!event.getAction().isRightClick() || !event.hasBlock()) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null || clickedBlock.getType() != Material.DROPPER || !this.autoCrafterManager.isAutoCrafterBlock(clickedBlock)) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.plugin.getFeatureToggleManager().isFeatureEnabled(player, "autocrafter")) {
            MessageUtils.sendError((CommandSender)player, "autocrafter.feature_disabled", new Object[0]);
            event.setCancelled(true);
            return;
        }
        if (player.isSneaking()) {
            return;
        }
        event.setCancelled(true);
        AutoCrafterGUI gui = new AutoCrafterGUI(this.plugin, clickedBlock.getLocation());
        player.openInventory(gui.getInventory());
        this.openedGUIs.put(player.getUniqueId(), gui);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        if (!this.plugin.getConfigManager().getDefaultFeatureStatus("autocrafter")) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        AutoCrafterGUI gui = this.openedGUIs.get(player.getUniqueId());
        if (gui == null) {
            return;
        }
        if (event.getClickedInventory() != gui.getInventory() && event.isShiftClick()) {
            event.setCancelled(true);
            ItemStack clickedItem = event.getCurrentItem();
            if (clickedItem != null && clickedItem.getType() != Material.AIR) {
                gui.handleShiftClick(clickedItem);
                player.updateInventory();
            }
            return;
        }
        if (event.getInventory().equals(gui.getInventory())) {
            gui.handleGuiClick(event);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!this.plugin.getConfigManager().getDefaultFeatureStatus("autocrafter")) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        AutoCrafterGUI gui = this.openedGUIs.get(player.getUniqueId());
        if (gui != null && event.getInventory().equals(gui.getInventory())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!this.plugin.getConfigManager().getDefaultFeatureStatus("autocrafter")) {
            return;
        }
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        AutoCrafterGUI gui = this.openedGUIs.remove(player.getUniqueId());
        if (gui != null && event.getInventory().equals(gui.getInventory())) {
            gui.saveItemsToDropper();
        }
    }
}

