/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.autocrafter;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.modules.autocrafter.AutoCrafterManager;
import ethertaco.sundries.utils.MessageUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Dropper;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AutoCrafterGUI {
    private final Sundries plugin;
    private final AutoCrafterManager autoCrafterManager;
    private final Location dropperLocation;
    private final Inventory guiInventory;
    private static final int GUI_SIZE = 27;
    private static final int CRAFTING_SLOTS_START = 0;
    private static final int CRAFTING_SLOTS_END = 8;
    private static final ItemStack LOCKED_SLOT_BARRIER = new ItemStack(Material.BARRIER);
    private static final ItemStack UNLOCKED_SLOT_INDICATOR;
    private static final ItemStack BACKGROUND_ITEM;
    private static final ItemStack INFO_ITEM;

    public AutoCrafterGUI(Sundries plugin, Location dropperLocation) {
        this.plugin = plugin;
        this.autoCrafterManager = plugin.getAutoCrafterManager();
        this.dropperLocation = dropperLocation;
        this.guiInventory = Bukkit.createInventory(null, (int)27, (Component)MessageUtils.miniMessage.deserialize((Object)plugin.getLangManager().getMessage("autocrafter.gui_title")));
        this.updateCraftingSlotDisplay();
        for (int i = 9; i < 27; ++i) {
            this.guiInventory.setItem(i, BACKGROUND_ITEM.clone());
        }
        this.updateLockToggleButtons();
        this.guiInventory.setItem(26, INFO_ITEM.clone());
    }

    private Dropper getDropperBlockState() {
        Block block;
        if (!this.dropperLocation.isWorldLoaded() || !this.dropperLocation.getChunk().isLoaded()) {
            this.dropperLocation.getChunk().load();
        }
        return (block = this.dropperLocation.getBlock()).getState() instanceof Dropper ? (Dropper)block.getState() : null;
    }

    private void updateLockToggleButtons() {
        Set<Integer> lockedSlots = this.autoCrafterManager.getLockedSlots(this.dropperLocation);
        for (int i = 0; i <= 8; ++i) {
            this.guiInventory.setItem(9 + i, lockedSlots.contains(i) ? LOCKED_SLOT_BARRIER.clone() : UNLOCKED_SLOT_INDICATOR.clone());
        }
    }

    public void handleGuiClick(InventoryClickEvent event) {
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        int rawSlot = event.getRawSlot();
        if (rawSlot < 0 || rawSlot >= 27) {
            return;
        }
        if (rawSlot > 8) {
            if (rawSlot >= 9 && rawSlot <= 17) {
                this.toggleLock(player, rawSlot - 9);
            }
            return;
        }
        ItemStack cursorItem = event.getCursor();
        ItemStack currentItem = event.getCurrentItem();
        boolean isLocked = this.autoCrafterManager.getLockedSlots(this.dropperLocation).contains(rawSlot);
        if (currentItem != null && currentItem.isSimilar(LOCKED_SLOT_BARRIER)) {
            if (cursorItem != null && cursorItem.getType() != Material.AIR) {
                MessageUtils.sendError((CommandSender)player, "autocrafter.slot_is_locked", new Object[0]);
            }
            return;
        }
        if (event.getClick() == ClickType.LEFT) {
            player.setItemOnCursor(currentItem);
            this.guiInventory.setItem(rawSlot, cursorItem);
        } else if (event.getClick() == ClickType.RIGHT) {
            if (cursorItem != null && cursorItem.getType() != Material.AIR) {
                if (currentItem == null || currentItem.getType() == Material.AIR) {
                    this.guiInventory.setItem(rawSlot, cursorItem.asOne());
                    cursorItem.subtract(1);
                } else if (currentItem.isSimilar(cursorItem) && currentItem.getAmount() < currentItem.getMaxStackSize()) {
                    currentItem.add(1);
                    cursorItem.subtract(1);
                }
            } else if (currentItem != null && currentItem.getType() != Material.AIR) {
                int half = (int)Math.ceil((double)currentItem.getAmount() / 2.0);
                ItemStack halfStack = currentItem.clone();
                halfStack.setAmount(half);
                player.setItemOnCursor(halfStack);
                currentItem.subtract(half);
            }
        }
        this.saveItemsToDropper();
    }

    public void handleShiftClick(ItemStack clickedItem) {
        for (int i = 0; i <= 8; ++i) {
            if (this.autoCrafterManager.getLockedSlots(this.dropperLocation).contains(i)) continue;
            ItemStack slotItem = this.guiInventory.getItem(i);
            if (slotItem == null || slotItem.getType() == Material.AIR) {
                this.guiInventory.setItem(i, clickedItem.clone());
                clickedItem.setAmount(0);
                break;
            }
            if (!slotItem.isSimilar(clickedItem) || slotItem.getAmount() >= slotItem.getMaxStackSize()) continue;
            int canTake = slotItem.getMaxStackSize() - slotItem.getAmount();
            int willTake = Math.min(canTake, clickedItem.getAmount());
            slotItem.add(willTake);
            clickedItem.subtract(willTake);
            if (clickedItem.getAmount() <= 0) break;
        }
        this.saveItemsToDropper();
    }

    private void toggleLock(Player player, int slotIndex) {
        Set<Integer> currentLockedSlots = this.autoCrafterManager.getLockedSlots(this.dropperLocation);
        HashSet<Integer> newLockedSlots = new HashSet<Integer>(currentLockedSlots);
        if (newLockedSlots.contains(slotIndex)) {
            newLockedSlots.remove(slotIndex);
            MessageUtils.sendSuccess((CommandSender)player, "autocrafter.slot_unlocked", "slot_index", slotIndex + 1);
        } else {
            newLockedSlots.add(slotIndex);
            MessageUtils.sendSuccess((CommandSender)player, "autocrafter.slot_locked", "slot_index", slotIndex + 1);
        }
        this.autoCrafterManager.setLockedSlots(this.dropperLocation, newLockedSlots);
        this.updateCraftingSlotDisplay();
        this.updateLockToggleButtons();
    }

    public void saveItemsToDropper() {
        Dropper dropper = this.getDropperBlockState();
        if (dropper == null) {
            return;
        }
        for (int i = 0; i <= 8; ++i) {
            ItemStack guiItem = this.guiInventory.getItem(i);
            if (guiItem != null && guiItem.isSimilar(LOCKED_SLOT_BARRIER)) {
                dropper.getInventory().setItem(i, null);
                continue;
            }
            dropper.getInventory().setItem(i, guiItem);
        }
        dropper.update(true);
    }

    public void updateCraftingSlotDisplay() {
        Dropper dropper = this.getDropperBlockState();
        if (dropper == null) {
            return;
        }
        Set<Integer> lockedSlots = this.autoCrafterManager.getLockedSlots(this.dropperLocation);
        for (int i = 0; i <= 8; ++i) {
            ItemStack itemInDropper = dropper.getInventory().getItem(i);
            if (lockedSlots.contains(i) && (itemInDropper == null || itemInDropper.getType() == Material.AIR)) {
                this.guiInventory.setItem(i, LOCKED_SLOT_BARRIER.clone());
                continue;
            }
            this.guiInventory.setItem(i, itemInDropper != null ? itemInDropper.clone() : null);
        }
    }

    public Inventory getInventory() {
        return this.guiInventory;
    }

    static {
        ItemMeta barrierMeta = LOCKED_SLOT_BARRIER.getItemMeta();
        barrierMeta.displayName(MessageUtils.miniMessage.deserialize((Object)"<red>\u5df2\u9501\u5b9a\u683c\u5b50</red>"));
        barrierMeta.lore(Arrays.asList(MessageUtils.miniMessage.deserialize((Object)"<gray>\u53f3\u952e\u70b9\u51fb\u4ee5\u89e3\u9501</gray>"), MessageUtils.miniMessage.deserialize((Object)"<gray>\u6b64\u683c\u5b50\u4e2d\u7684\u7269\u54c1\u4e0d\u4f1a\u88ab\u6d88\u8017</gray>")));
        LOCKED_SLOT_BARRIER.setItemMeta(barrierMeta);
        UNLOCKED_SLOT_INDICATOR = new ItemStack(Material.LIME_STAINED_GLASS_PANE);
        ItemMeta unlockedMeta = UNLOCKED_SLOT_INDICATOR.getItemMeta();
        unlockedMeta.displayName(MessageUtils.miniMessage.deserialize((Object)"<green>\u672a\u9501\u5b9a\u683c\u5b50</green>"));
        unlockedMeta.lore(Arrays.asList(MessageUtils.miniMessage.deserialize((Object)"<gray>\u53f3\u952e\u70b9\u51fb\u4ee5\u9501\u5b9a</gray>"), MessageUtils.miniMessage.deserialize((Object)"<gray>\u6b64\u683c\u5b50\u4e2d\u7684\u7269\u54c1\u5c06\u88ab\u6d88\u8017</gray>")));
        UNLOCKED_SLOT_INDICATOR.setItemMeta(unlockedMeta);
        BACKGROUND_ITEM = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta backgroundMeta = BACKGROUND_ITEM.getItemMeta();
        backgroundMeta.displayName((Component)Component.empty());
        BACKGROUND_ITEM.setItemMeta(backgroundMeta);
        INFO_ITEM = new ItemStack(Material.LIGHT_GRAY_CONCRETE);
        ItemMeta infoMeta = INFO_ITEM.getItemMeta();
        infoMeta.displayName(MessageUtils.miniMessage.deserialize((Object)"<aqua>\u81ea\u52a8\u5408\u6210\u5668\u4fe1\u606f</aqua>"));
        infoMeta.lore(Arrays.asList(MessageUtils.miniMessage.deserialize((Object)"<gray>\u5c06\u5408\u6210\u6750\u6599\u653e\u5165\u9876\u90e8\u76849\u4e2a\u683c\u5b50\u3002</gray>"), MessageUtils.miniMessage.deserialize((Object)"<gray>\u53f3\u952e\u70b9\u51fb\u4e0b\u65b9\u683c\u5b50\u4ee5\u9501\u5b9a/\u89e3\u9501\u5bf9\u5e94\u5408\u6210\u69fd\u3002</gray>"), MessageUtils.miniMessage.deserialize((Object)"<gray>\u9501\u5b9a\u540e\uff0c\u8be5\u683c\u5b50\u4e2d\u7684\u7269\u54c1\u4e0d\u4f1a\u88ab\u6d88\u8017\u3002</gray>"), MessageUtils.miniMessage.deserialize((Object)"<gray>\u7ea2\u77f3\u4fe1\u53f7\u5c06\u89e6\u53d1\u5408\u6210\u3002</gray>")));
        INFO_ITEM.setItemMeta(infoMeta);
    }
}

