/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.autocrafter;

import ethertaco.sundries.Sundries;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class AutoCrafterConfig {
    private final Sundries plugin;
    private File autoCrafterConfigFile;
    private FileConfiguration autoCrafterConfig;
    private final Map<String, Set<Integer>> loadedAutoCrafters = new HashMap<String, Set<Integer>>();

    public AutoCrafterConfig(Sundries plugin) {
        this.plugin = plugin;
        this.setupAutoCrafterConfig();
        this.loadConfig();
    }

    private void setupAutoCrafterConfig() {
        File modulesFolder = new File(this.plugin.getDataFolder(), "modules");
        if (!modulesFolder.exists()) {
            modulesFolder.mkdirs();
        }
        this.autoCrafterConfigFile = new File(modulesFolder, "autocrafter.yml");
        if (!this.autoCrafterConfigFile.exists()) {
            this.plugin.saveResource("modules/autocrafter.yml", false);
        }
        this.autoCrafterConfig = YamlConfiguration.loadConfiguration((File)this.autoCrafterConfigFile);
    }

    public void reloadConfig() {
        this.autoCrafterConfig = YamlConfiguration.loadConfiguration((File)this.autoCrafterConfigFile);
        this.loadConfig();
        this.plugin.getLogger().info("modules/autocrafter.yml reloaded.");
    }

    private void loadConfig() {
        this.loadedAutoCrafters.clear();
        if (this.autoCrafterConfig.contains("autocrafters")) {
            for (String key : this.autoCrafterConfig.getConfigurationSection("autocrafters").getKeys(false)) {
                List lockedSlotsList = this.autoCrafterConfig.getIntegerList("autocrafters." + key + ".locked_slots");
                this.loadedAutoCrafters.put(key, new HashSet(lockedSlotsList));
            }
        }
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[AutoCrafterConfig] Loaded %d auto crafters from config.", this.loadedAutoCrafters.size()));
        }
    }

    public void saveConfig() {
        this.autoCrafterConfig.set("autocrafters", null);
        this.loadedAutoCrafters.forEach((key, lockedSlots) -> this.autoCrafterConfig.set("autocrafters." + key + ".locked_slots", new ArrayList(lockedSlots)));
        try {
            this.autoCrafterConfig.save(this.autoCrafterConfigFile);
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[AutoCrafterConfig] Saved %d auto crafters to config.", this.loadedAutoCrafters.size()));
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save modules/autocrafter.yml: " + e.getMessage());
        }
    }

    public static String getLocationKey(Location location) {
        return String.format("%s_%d_%d_%d", location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static Location getLocationFromKey(Sundries plugin, String key) {
        String[] parts = key.split("_");
        if (parts.length != 4) {
            return null;
        }
        String worldName = parts[0];
        World world = plugin.getServer().getWorld(worldName);
        if (world == null) {
            return null;
        }
        try {
            int x = Integer.parseInt(parts[1]);
            int y = Integer.parseInt(parts[2]);
            int z = Integer.parseInt(parts[3]);
            return new Location(world, (double)x, (double)y, (double)z);
        }
        catch (NumberFormatException e) {
            plugin.getLogger().warning("Invalid number format in location key: " + key);
            return null;
        }
    }

    public boolean isAutoCrafter(Location location) {
        return this.loadedAutoCrafters.containsKey(AutoCrafterConfig.getLocationKey(location));
    }

    public Set<Integer> getLockedSlots(Location location) {
        return this.loadedAutoCrafters.getOrDefault(AutoCrafterConfig.getLocationKey(location), Collections.emptySet());
    }

    public void setLockedSlots(Location location, Set<Integer> lockedSlots) {
        String key = AutoCrafterConfig.getLocationKey(location);
        if (lockedSlots == null || lockedSlots.isEmpty()) {
            this.loadedAutoCrafters.remove(key);
        } else {
            this.loadedAutoCrafters.put(key, new HashSet<Integer>(lockedSlots));
        }
        this.saveConfig();
    }

    public void addAutoCrafter(Location location) {
        this.loadedAutoCrafters.putIfAbsent(AutoCrafterConfig.getLocationKey(location), new HashSet());
        this.saveConfig();
    }

    public void removeAutoCrafter(Location location) {
        this.loadedAutoCrafters.remove(AutoCrafterConfig.getLocationKey(location));
        this.saveConfig();
    }

    public Set<String> getAllAutoCrafterKeys() {
        return this.loadedAutoCrafters.keySet();
    }
}

