/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.autocrafter;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.commands.AbstractCommand;
import ethertaco.sundries.modules.autocrafter.AutoCrafterManager;
import ethertaco.sundries.utils.MessageUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AutoCrafterCommand
extends AbstractCommand {
    private final AutoCrafterManager autoCrafterManager;

    public AutoCrafterCommand(Sundries plugin) {
        super(plugin, "autocrafter", "sundries.command.autocrafter");
        this.autoCrafterManager = plugin.getAutoCrafterManager();
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!this.plugin.getConfigManager().getDefaultFeatureStatus("autocrafter")) {
            return true;
        }
        if (!this.checkPermission(sender)) {
            return true;
        }
        Player targetPlayer = null;
        if (args.length == 0) {
            if (!this.isPlayer(sender)) {
                this.sendUsage(sender, "/su autocrafter give [player]");
                return true;
            }
            targetPlayer = (Player)sender;
        } else if (args.length == 1 && args[0].equalsIgnoreCase("give")) {
            if (!this.isPlayer(sender)) {
                this.sendUsage(sender, "/su autocrafter give [player]");
                return true;
            }
            targetPlayer = (Player)sender;
        } else if (args.length == 2 && args[0].equalsIgnoreCase("give")) {
            targetPlayer = Bukkit.getPlayer((String)args[1]);
            if (targetPlayer == null) {
                MessageUtils.sendError(sender, "command.not_online", "player_name", args[1]);
                return false;
            }
        } else {
            this.sendUsage(sender, "/su autocrafter give [player]");
            return false;
        }
        if (!this.plugin.getFeatureToggleManager().isFeatureEnabled(targetPlayer, "autocrafter")) {
            MessageUtils.sendError(sender, "autocrafter.feature_disabled_for_player", "player_name", targetPlayer.getName());
            return true;
        }
        ItemStack autocrafterItem = this.autoCrafterManager.getAutoCrafterItem();
        targetPlayer.getInventory().addItem(new ItemStack[]{autocrafterItem});
        MessageUtils.sendSuccess(sender, "autocrafter.give_success", "player_name", targetPlayer.getName());
        if (sender != targetPlayer) {
            MessageUtils.sendMessage((Audience)targetPlayer, "autocrafter.given_by_other", "sender_name", sender.getName());
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (!this.plugin.getConfigManager().getDefaultFeatureStatus("autocrafter")) {
            return Collections.emptyList();
        }
        if (!sender.hasPermission(this.permission)) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return Arrays.asList("give").stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("give")) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

