/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.afk;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.config.ConfigManager;
import ethertaco.sundries.managers.FeatureToggleManager;
import ethertaco.sundries.modules.fly.FlyManager;
import ethertaco.sundries.modules.god.GodManager;
import ethertaco.sundries.utils.MessageUtils;
import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class AFKManager {
    private final Sundries plugin;
    private final ConfigManager configManager;
    private final FeatureToggleManager featureToggleManager;
    private final FlyManager flyManager;
    private final GodManager godManager;
    private final Map<UUID, AFKPlayerState> afkStates = new HashMap<UUID, AFKPlayerState>();
    private BukkitTask afkCheckTask;
    private final Set<UUID> noCollisionPlayers = new HashSet<UUID>();

    public AFKManager(Sundries plugin, ConfigManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.featureToggleManager = plugin.getFeatureToggleManager();
        this.flyManager = plugin.getFlyManager();
        this.godManager = plugin.getGodManager();
        this.startAFKCheckTask();
    }

    private void startAFKCheckTask() {
        if (this.afkCheckTask != null) {
            this.afkCheckTask.cancel();
        }
        this.afkCheckTask = new BukkitRunnable(){

            public void run() {
                if (!AFKManager.this.configManager.isPluginEnabled() || !AFKManager.this.configManager.isAfkEnabled()) {
                    return;
                }
                long afkTimeoutMillis = (long)(AFKManager.this.configManager.getAfkTimeoutMinutes() * 60) * 1000L;
                Instant now = Instant.now();
                for (Player player : AFKManager.this.plugin.getServer().getOnlinePlayers()) {
                    AFKManager.this.afkStates.computeIfAbsent(player.getUniqueId(), uuid -> new AFKPlayerState(player));
                    AFKPlayerState state = AFKManager.this.afkStates.get(player.getUniqueId());
                    if (!AFKManager.this.featureToggleManager.isFeatureEnabled(player, "afk")) {
                        if (!state.isAFK) continue;
                        AFKManager.this.setPlayerAFK(player, false, false, null);
                        continue;
                    }
                    if (state.isAFK) {
                        if (!AFKManager.this.noCollisionPlayers.contains(player.getUniqueId())) {
                            player.setCollidable(false);
                            AFKManager.this.noCollisionPlayers.add(player.getUniqueId());
                            player.setInvulnerable(true);
                            if (AFKManager.this.configManager.getDebugMode()) {
                                AFKManager.this.plugin.getLogger().fine(String.format("[AFKManager] Re-applying no-collision/invulnerability for AFK player %s.", player.getName()));
                            }
                        }
                        if (!AFKManager.this.configManager.isAfkSubtitleEnabled()) continue;
                        MessageUtils.sendSubtitle((Audience)player, "afk.subtitle_afk", "player_name", player.getName());
                        continue;
                    }
                    if (now.toEpochMilli() - state.lastActivity.toEpochMilli() < afkTimeoutMillis) continue;
                    AFKManager.this.setPlayerAFK(player, true, true, null);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 20L);
    }

    public void setPlayerAFK(Player player, boolean afk, boolean sendMessages, String sourceName) {
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().info(String.format("[AFKManager] Setting AFK status for %s to %s (sendMessages: %s, source: %s).", player.getName(), afk, sendMessages, sourceName));
        }
        if (!this.featureToggleManager.isFeatureEnabled(player, "afk")) {
            if (sendMessages && sourceName != null) {
                Player sourcePlayer = Bukkit.getPlayer((String)sourceName);
                if (sourcePlayer != null) {
                    MessageUtils.sendError((CommandSender)sourcePlayer, "command.afk.feature_disabled_for_player", "player_name", player.getName());
                }
            } else if (sendMessages) {
                MessageUtils.sendError((CommandSender)player, "command.afk.feature_disabled", new Object[0]);
            }
            return;
        }
        AFKPlayerState state = this.afkStates.computeIfAbsent(player.getUniqueId(), uuid -> new AFKPlayerState(player));
        if (state.isAFK == afk) {
            if (sendMessages && afk) {
                MessageUtils.sendInfo((CommandSender)player, "command.afk.already_afk", new Object[0]);
            }
            return;
        }
        state.isAFK = afk;
        state.lastActivity = Instant.now();
        this.updateLastLocation(player);
        if (afk) {
            if (sendMessages) {
                if (sourceName == null) {
                    MessageUtils.sendSuccess((CommandSender)player, "command.afk.enter_self", new Object[0]);
                } else {
                    MessageUtils.sendMessage((Audience)player, "command.afk.enter_by_other", "sender_name", sourceName);
                }
            }
            this.broadcastAFKStatus(player, true);
            if (this.configManager.isAfkSubtitleEnabled()) {
                MessageUtils.showTitle((Audience)player, "afk.subtitle_afk", "player_name", player.getName());
            }
            player.setCollidable(false);
            this.noCollisionPlayers.add(player.getUniqueId());
            player.setInvulnerable(true);
            if (player.getAllowFlight() && (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR)) {
                player.setFlying(false);
                player.setAllowFlight(false);
                if (this.configManager.getDebugMode()) {
                    this.plugin.getLogger().fine(String.format("[AFKManager] Player %s was flying in creative/spectator and entered AFK, flight disabled.", player.getName()));
                }
            }
        } else {
            if (sendMessages) {
                if (sourceName == null) {
                    MessageUtils.sendSuccess((CommandSender)player, "command.afk.exit_self", new Object[0]);
                } else {
                    MessageUtils.sendMessage((Audience)player, "command.afk.exit_by_other", "sender_name", sourceName);
                }
            }
            this.broadcastAFKStatus(player, false);
            if (this.configManager.isAfkSubtitleEnabled()) {
                MessageUtils.hideTitle((Audience)player);
            }
            player.setCollidable(true);
            this.noCollisionPlayers.remove(player.getUniqueId());
            if (this.godManager.isGodMode(player)) {
                this.godManager.setGodMode(player, true);
                if (this.configManager.getDebugMode()) {
                    this.plugin.getLogger().fine(String.format("[AFKManager] Player %s exited AFK, re-applied God mode.", player.getName()));
                }
            } else {
                player.setInvulnerable(false);
                AttributeInstance maxHealthAttribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
                if (maxHealthAttribute != null) {
                    player.setHealth(maxHealthAttribute.getValue());
                } else {
                    player.setHealth(20.0);
                }
            }
            this.flyManager.restorePlayerFlightState(player);
        }
    }

    private void broadcastAFKStatus(Player target, boolean isAfk) {
        String messageKey = isAfk ? "afk.broadcast_enter" : "afk.broadcast_exit";
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            if (!onlinePlayer.hasPermission("sundries.feature.afk.see-broadcast")) continue;
            MessageUtils.sendMessage((Audience)onlinePlayer, messageKey, "player_name", target.getName());
        }
    }

    public boolean isAFK(Player player) {
        AFKPlayerState state = this.afkStates.get(player.getUniqueId());
        return state != null && state.isAFK;
    }

    public void resetActivity(Player player) {
        if (this.isAFK(player)) {
            this.setPlayerAFK(player, false, true, null);
        } else {
            this.afkStates.computeIfAbsent((UUID)player.getUniqueId(), (Function<UUID, AFKPlayerState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$resetActivity$1(org.bukkit.entity.Player java.util.UUID ), (Ljava/util/UUID;)Lethertaco/sundries/modules/afk/AFKManager$AFKPlayerState;)((Player)player)).lastActivity = Instant.now();
            this.updateLastLocation(player);
        }
    }

    private void updateLastLocation(Player player) {
        AFKPlayerState state = this.afkStates.computeIfAbsent(player.getUniqueId(), uuid -> new AFKPlayerState(player));
        state.lastLocation = player.getLocation();
        state.lastYaw = player.getLocation().getYaw();
        state.lastPitch = player.getLocation().getPitch();
        if (this.configManager.getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[AFKManager] Updated last location/activity for %s.", player.getName()));
        }
    }

    public Location getLastActivityLocation(Player player) {
        AFKPlayerState state = this.afkStates.get(player.getUniqueId());
        return state != null ? state.lastLocation : player.getLocation();
    }

    public float getLastActivityYaw(Player player) {
        AFKPlayerState state = this.afkStates.get(player.getUniqueId());
        return state != null ? state.lastYaw : player.getLocation().getYaw();
    }

    public float getLastActivityPitch(Player player) {
        AFKPlayerState state = this.afkStates.get(player.getUniqueId());
        return state != null ? state.lastPitch : player.getLocation().getPitch();
    }

    public void cleanup() {
        if (this.afkCheckTask != null) {
            this.afkCheckTask.cancel();
        }
        for (UUID uuid : new HashSet<UUID>(this.afkStates.keySet())) {
            Player player = this.plugin.getServer().getPlayer(uuid);
            if (player == null || !player.isOnline()) continue;
            this.setPlayerAFK(player, false, false, null);
        }
        this.afkStates.clear();
        this.noCollisionPlayers.clear();
        this.plugin.getLogger().info("[AFKManager] All AFK states cleaned up.");
    }

    public void onPlayerJoin(Player player) {
        this.afkStates.put(player.getUniqueId(), new AFKPlayerState(player));
        if (!this.featureToggleManager.isFeatureEnabled(player, "afk")) {
            this.setPlayerAFK(player, false, false, null);
        } else {
            this.setPlayerAFK(player, false, false, null);
        }
    }

    public void onPlayerQuit(Player player) {
        if (this.afkStates.containsKey(player.getUniqueId())) {
            if (this.isAFK(player)) {
                this.setPlayerAFK(player, false, false, null);
            }
            this.afkStates.remove(player.getUniqueId());
            this.noCollisionPlayers.remove(player.getUniqueId());
        }
    }

    private static /* synthetic */ AFKPlayerState lambda$resetActivity$1(Player player, UUID uuid) {
        return new AFKPlayerState(player);
    }

    private static class AFKPlayerState {
        boolean isAFK = false;
        Instant lastActivity = Instant.now();
        Location lastLocation;
        float lastYaw;
        float lastPitch;

        public AFKPlayerState(Player player) {
            this.lastLocation = player.getLocation();
            this.lastYaw = player.getLocation().getYaw();
            this.lastPitch = player.getLocation().getPitch();
        }
    }
}

