/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.afk;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.config.ConfigManager;
import ethertaco.sundries.modules.afk.AFKManager;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;

public class AFKListener
implements Listener {
    private final Sundries plugin;
    private final AFKManager afkManager;
    private final ConfigManager configManager;
    private Set<String> bypassDamageTypesCache;

    public AFKListener(Sundries plugin) {
        this.plugin = plugin;
        this.afkManager = plugin.getAFKManager();
        this.configManager = plugin.getConfigManager();
        this.loadBypassDamageTypes();
    }

    public void loadBypassDamageTypes() {
        this.bypassDamageTypesCache = this.plugin.getConfigManager().getAfkBypassDamageTypes().stream().map(String::toUpperCase).collect(Collectors.toSet());
        this.plugin.getLogger().info("AFK bypass damage types cache reloaded: " + this.bypassDamageTypesCache);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.configManager.isPluginEnabled()) {
            return;
        }
        this.afkManager.onPlayerJoin(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (!this.configManager.isPluginEnabled()) {
            return;
        }
        this.afkManager.onPlayerQuit(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (!this.configManager.isPluginEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.afkManager.isAFK(player)) {
            this.afkManager.setPlayerAFK(player, false, false, null);
            if (this.configManager.getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[AFKListener] Player %s respawned, automatically exited AFK.", player.getName()));
            }
        }
        this.afkManager.resetActivity(player);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (!this.configManager.isPluginEnabled() || !this.configManager.isAfkEnabled()) {
            return;
        }
        this.afkManager.resetActivity(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (!this.configManager.isPluginEnabled() || !this.configManager.isAfkEnabled()) {
            return;
        }
        String command = event.getMessage().split(" ")[0].toLowerCase();
        if (command.equals("/afk") || command.equals("/su") || command.equals("/sundries") || command.equals("/sun") || command.equals("/sd")) {
            return;
        }
        this.afkManager.resetActivity(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!this.configManager.isPluginEnabled() || !this.configManager.isAfkEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.afkManager.isAFK(player)) {
            Location from = this.afkManager.getLastActivityLocation(player);
            Location to = event.getTo();
            if (to == null) {
                return;
            }
            if (!this.configManager.isAfkAllowMoveToExit()) {
                if (from.getX() != to.getX() || from.getY() != to.getY() || from.getZ() != to.getZ()) {
                    player.teleport(from);
                    if (this.configManager.getDebugMode()) {
                        this.plugin.getLogger().fine(String.format("[AFKListener] Player %s was pushed while AFK (move-to-exit: false). Teleported back.", player.getName()));
                    }
                    return;
                }
            } else if (from.getWorld().equals(to.getWorld()) && from.distanceSquared(to) > 1.0) {
                this.afkManager.resetActivity(player);
                if (this.configManager.getDebugMode()) {
                    this.plugin.getLogger().fine(String.format("[AFKListener] Player %s moved significantly (%.2f blocks), exited AFK (move-to-exit: true).", player.getName(), Math.sqrt(from.distanceSquared(to))));
                }
                return;
            }
            float lastYaw = this.afkManager.getLastActivityYaw(player);
            float currentYaw = to.getYaw();
            float deltaYaw = Math.abs(currentYaw - lastYaw);
            if (deltaYaw > 180.0f) {
                deltaYaw = 360.0f - deltaYaw;
            }
            float lastPitch = this.afkManager.getLastActivityPitch(player);
            float currentPitch = to.getPitch();
            float deltaPitch = Math.abs(currentPitch - lastPitch);
            if (deltaYaw > 30.0f || deltaPitch > 30.0f) {
                this.afkManager.resetActivity(player);
                if (this.configManager.getDebugMode()) {
                    this.plugin.getLogger().fine(String.format("[AFKListener] Player %s rotated view significantly (Yaw: %.1f, Pitch: %.1f), exited AFK.", player.getName(), Float.valueOf(deltaYaw), Float.valueOf(deltaPitch)));
                }
            }
        } else {
            this.afkManager.resetActivity(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        Player player;
        if (!this.configManager.isPluginEnabled() || !this.configManager.isAfkEnabled()) {
            return;
        }
        if (event.getEntity() instanceof Player && this.afkManager.isAFK(player = (Player)event.getEntity())) {
            if (!this.bypassDamageTypesCache.contains(event.getCause().name())) {
                event.setCancelled(true);
                if (this.configManager.getDebugMode()) {
                    this.plugin.getLogger().fine(String.format("[AFKListener] Prevented %s from taking damage (%s) while AFK.", player.getName(), event.getCause().name()));
                }
            } else {
                if (this.configManager.getDebugMode()) {
                    this.plugin.getLogger().fine(String.format("[AFKListener] AFK player %s took bypass damage (%s).", player.getName(), event.getCause().name()));
                }
                this.afkManager.resetActivity(player);
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onEntityTarget(EntityTargetLivingEntityEvent event) {
        Player targetPlayer;
        if (!this.configManager.isPluginEnabled() || !this.configManager.isAfkEnabled()) {
            return;
        }
        if (event.getTarget() instanceof Player && this.afkManager.isAFK(targetPlayer = (Player)event.getTarget())) {
            event.setCancelled(true);
            if (this.configManager.getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[AFKListener] Prevented entity %s from targeting AFK player %s.", event.getEntity().getName(), targetPlayer.getName()));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(EntityDeathEvent event) {
        Player player;
        if (!this.configManager.isPluginEnabled() || !this.configManager.isAfkEnabled()) {
            return;
        }
        if (event.getEntity() instanceof Player && this.afkManager.isAFK(player = (Player)event.getEntity())) {
            this.afkManager.setPlayerAFK(player, false, false, null);
            if (this.configManager.getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[AFKListener] Player %s died, automatically exited AFK.", player.getName()));
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        if (!this.configManager.isPluginEnabled() || !this.configManager.isAfkEnabled()) {
            return;
        }
        this.afkManager.resetActivity(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.configManager.isPluginEnabled() || !this.configManager.isAfkEnabled()) {
            return;
        }
        if (event.getAction().isLeftClick() && !event.hasBlock()) {
            return;
        }
        this.afkManager.resetActivity(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (!this.configManager.isPluginEnabled() || !this.configManager.isAfkEnabled()) {
            return;
        }
        this.afkManager.resetActivity(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        if (!this.configManager.isPluginEnabled() || !this.configManager.isAfkEnabled()) {
            return;
        }
        this.afkManager.resetActivity(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!this.configManager.isPluginEnabled() || !this.configManager.isAfkEnabled()) {
            return;
        }
        this.afkManager.resetActivity(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.configManager.isPluginEnabled() || !this.configManager.isAfkEnabled()) {
            return;
        }
        this.afkManager.resetActivity(event.getPlayer());
    }
}

