/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.modules.afk;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.commands.AbstractCommand;
import ethertaco.sundries.modules.afk.AFKManager;
import ethertaco.sundries.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AFKCommand
extends AbstractCommand {
    private final AFKManager afkManager;

    public AFKCommand(Sundries plugin) {
        super(plugin, "afk", "sundries.command.afk.self");
        this.afkManager = plugin.getAFKManager();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean execute(CommandSender sender, String[] args) {
        Player targetPlayer = null;
        Boolean newState = null;
        if (args.length == 0) {
            if (!this.isPlayer(sender)) {
                return true;
            }
            targetPlayer = (Player)sender;
            if (!sender.hasPermission("sundries.command.afk.self")) {
                MessageUtils.sendError(sender, "command.no_permission", "permission", "sundries.command.afk.self");
                return true;
            }
        } else if (args.length == 1) {
            String arg0 = args[0].toLowerCase();
            if (arg0.equals("on") || arg0.equals("off")) {
                if (!this.isPlayer(sender)) {
                    return true;
                }
                targetPlayer = (Player)sender;
                if (!sender.hasPermission("sundries.command.afk.self")) {
                    MessageUtils.sendError(sender, "command.no_permission", "permission", "sundries.command.afk.self");
                    return true;
                }
                newState = arg0.equals("on");
            } else {
                if (!sender.hasPermission("sundries.command.afk.others")) {
                    MessageUtils.sendError(sender, "command.no_permission", "permission", "sundries.command.afk.others");
                    return true;
                }
                targetPlayer = Bukkit.getPlayer((String)args[0]);
            }
        } else {
            if (args.length != 2) {
                this.sendUsage(sender, "/su afk [player] [on|off]");
                return false;
            }
            if (!sender.hasPermission("sundries.command.afk.others")) {
                MessageUtils.sendError(sender, "command.no_permission", "permission", "sundries.command.afk.others");
                return true;
            }
            targetPlayer = Bukkit.getPlayer((String)args[0]);
            String arg1 = args[1].toLowerCase();
            if (!arg1.equals("on") && !arg1.equals("off")) {
                this.sendUsage(sender, "/su afk [player] [on|off]");
                return false;
            }
            newState = arg1.equals("on");
        }
        if (targetPlayer == null) {
            MessageUtils.sendError(sender, "command.not_online", "player_name", args[0]);
            return false;
        }
        boolean finalState = newState == null ? !this.afkManager.isAFK(targetPlayer) : newState;
        String senderName = sender.getName();
        this.afkManager.setPlayerAFK(targetPlayer, finalState, true, sender == targetPlayer ? null : senderName);
        if (sender == targetPlayer) return true;
        if (finalState) {
            MessageUtils.sendSuccess(sender, "command.afk.enabled_other", "player_name", targetPlayer.getName());
            return true;
        }
        MessageUtils.sendSuccess(sender, "command.afk.disabled_other", "player_name", targetPlayer.getName());
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            if (sender.hasPermission("sundries.command.afk.self")) {
                completions.addAll(Arrays.asList("on", "off"));
            }
            if (sender.hasPermission("sundries.command.afk.others")) {
                completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList()));
            }
            return completions.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && sender.hasPermission("sundries.command.afk.others")) {
            return Arrays.asList("on", "off").stream().filter(s -> s.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

