/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.managers;

import ethertaco.sundries.Sundries;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;

public class LangManager {
    private final Sundries plugin;
    private final Map<String, String> messages = new HashMap<String, String>();
    private String currentLocale = "en_US";

    public LangManager(Sundries plugin) {
        this.plugin = plugin;
        this.saveDefaultLocales();
    }

    private void saveDefaultLocales() {
        File localeFolder = new File(this.plugin.getDataFolder(), "locale");
        if (!localeFolder.exists()) {
            localeFolder.mkdirs();
        }
        this.plugin.saveResource("locale/locale_en_US.yml", false);
        this.plugin.saveResource("locale/locale_zh_CN.yml", false);
    }

    public void loadLocale(String localeCode) {
        this.messages.clear();
        Object fileName = "locale_" + localeCode + ".yml";
        File localeFile = new File(this.plugin.getDataFolder() + File.separator + "locale", (String)fileName);
        if (!localeFile.exists()) {
            this.plugin.getLogger().warning("Locale file '" + (String)fileName + "' not found. Falling back to 'en_US'.");
            localeCode = "en_US";
            fileName = "locale_en_US.yml";
            localeFile = new File(this.plugin.getDataFolder() + File.separator + "locale", (String)fileName);
        }
        YamlConfiguration langConfig = YamlConfiguration.loadConfiguration((File)localeFile);
        for (String key : langConfig.getKeys(true)) {
            this.messages.put(key, langConfig.getString(key));
        }
        this.currentLocale = localeCode;
        this.plugin.getLogger().info("Locale '" + localeCode + "' loaded.");
    }

    public String getMessage(String key) {
        return this.messages.getOrDefault(key, "Message not found: " + key);
    }

    public String getMessage(String key, Object ... placeholders) {
        String message = this.getMessage(key);
        for (int i = 0; i < placeholders.length; i += 2) {
            if (i + 1 >= placeholders.length) continue;
            message = message.replace("{" + String.valueOf(placeholders[i]) + "}", String.valueOf(placeholders[i + 1]));
        }
        return message;
    }

    public String getCurrentLocale() {
        return this.currentLocale;
    }

    public List<String> getAvailableLocales() {
        File[] files;
        File localeFolder = new File(this.plugin.getDataFolder(), "locale");
        ArrayList<String> locales = new ArrayList<String>();
        if (localeFolder.exists() && localeFolder.isDirectory() && (files = localeFolder.listFiles((dir, name) -> name.startsWith("locale_") && name.endsWith(".yml"))) != null) {
            for (File file : files) {
                String fileName = file.getName();
                String localeCode = fileName.substring("locale_".length(), fileName.length() - ".yml".length());
                locales.add(localeCode);
            }
        }
        return locales;
    }
}

