/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.managers;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.config.ConfigManager;
import ethertaco.sundries.config.FeatureConfig;
import java.util.Arrays;
import java.util.List;
import org.bukkit.entity.Player;

public class FeatureToggleManager {
    private final Sundries plugin;
    private final ConfigManager configManager;
    private final FeatureConfig featureConfig;
    public static final List<String> TOGGLEABLE_FEATURES = Arrays.asList("suicide", "furnace_speed", "sudo_bypass", "fly_persistence", "fly_speed_control", "sit", "sitonstairs", "sudo", "anvil", "craft", "ender", "afk", "god", "autocrafter", "mute", "mute.bypass");

    public FeatureToggleManager(Sundries plugin, ConfigManager configManager, FeatureConfig featureConfig) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.featureConfig = featureConfig;
    }

    public boolean isFeatureEnabled(Player player, String featureId) {
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[FeatureToggleManager] Checking feature '%s' for player '%s'.", featureId, player.getName()));
        }
        String playerKey = this.configManager.getPlayerStorageKey(player, "features");
        if (featureId.equals("sudo_bypass") || featureId.equals("mute.bypass")) {
            Boolean playerSpecificSetting = this.featureConfig.getPlayerFeatureStatus(playerKey, featureId);
            if (playerSpecificSetting != null) {
                if (this.plugin.getConfigManager().getDebugMode()) {
                    this.plugin.getLogger().fine(String.format("[FeatureToggleManager] %s: Player specific setting found for key '%s': %s.", featureId, playerKey, playerSpecificSetting));
                }
                return playerSpecificSetting;
            }
            if (player.isOp()) {
                if (this.plugin.getConfigManager().getDebugMode()) {
                    this.plugin.getLogger().fine(String.format("[FeatureToggleManager] %s: Player '%s' is OP. Defaulting to DISABLED.", featureId, player.getName()));
                }
                return false;
            }
            boolean globalDefault = this.configManager.getDefaultFeatureStatus(featureId);
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[FeatureToggleManager] %s: No player-specific or OP rule. Using global default: %s.", featureId, globalDefault));
            }
            return globalDefault;
        }
        if (player.hasPermission("sundries.feature.bypass")) {
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[FeatureToggleManager] Player '%s' has 'sundries.feature.bypass'. Feature '%s' is ENABLED.", player.getName(), featureId));
            }
            return true;
        }
        Boolean playerSpecificSetting = this.featureConfig.getPlayerFeatureStatus(playerKey, featureId);
        if (playerSpecificSetting != null) {
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[FeatureToggleManager] Player specific setting found for key '%s' for feature '%s': %s.", playerKey, featureId, playerSpecificSetting));
            }
            return playerSpecificSetting;
        }
        if (player.isOp()) {
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().fine(String.format("[FeatureToggleManager] Player '%s' is OP. Feature '%s' is ENABLED (OP default).", player.getName(), featureId));
            }
            return true;
        }
        boolean globalDefault = this.configManager.getDefaultFeatureStatus(featureId);
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().fine(String.format("[FeatureToggleManager] No player-specific or OP rule for '%s'. Using global default: %s.", featureId, globalDefault));
        }
        return globalDefault;
    }

    public boolean getDefaultGlobalFeatureStatus(String featureId) {
        return this.configManager.getDefaultFeatureStatus(featureId);
    }

    public void setDefaultGlobalFeatureStatus(String featureId, boolean enabled) {
        this.configManager.setDefaultFeatureStatus(featureId, enabled);
    }

    public void setPlayerFeatureStatus(String playerKey, String featureId, boolean enabled) {
        this.featureConfig.setPlayerFeatureStatus(playerKey, featureId, enabled);
    }

    public void removePlayerFeatureStatus(String playerKey, String featureId) {
        this.featureConfig.removePlayerFeatureStatus(playerKey, featureId);
    }
}

