/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.config;

import ethertaco.sundries.Sundries;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class FeatureConfig {
    private final Sundries plugin;
    private File featureConfigFile;
    private FileConfiguration featureConfig;

    public FeatureConfig(Sundries plugin) {
        this.plugin = plugin;
        this.setupFeatureConfig();
    }

    private void setupFeatureConfig() {
        this.featureConfigFile = new File(this.plugin.getDataFolder(), "features.yml");
        if (!this.featureConfigFile.exists()) {
            this.plugin.saveResource("features.yml", false);
        }
        this.featureConfig = YamlConfiguration.loadConfiguration((File)this.featureConfigFile);
    }

    public void reloadConfig() {
        this.featureConfig = YamlConfiguration.loadConfiguration((File)this.featureConfigFile);
        this.plugin.getLogger().info("features.yml reloaded.");
    }

    public void saveConfig() {
        try {
            this.featureConfig.save(this.featureConfigFile);
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().info("[FeatureConfig] Saved features.yml to " + this.featureConfigFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save features.yml: " + e.getMessage());
        }
    }

    public Boolean getPlayerFeatureStatus(String playerKey, String featureId) {
        if (!this.featureConfig.contains("players." + playerKey + "." + featureId)) {
            return null;
        }
        return this.featureConfig.getBoolean("players." + playerKey + "." + featureId);
    }

    public void setPlayerFeatureStatus(String playerKey, String featureId, boolean enabled) {
        this.featureConfig.set("players." + playerKey + "." + featureId, (Object)enabled);
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().info(String.format("[FeatureConfig] Setting player key '%s', feature '%s' to '%s'.", playerKey, featureId, enabled));
        }
        this.saveConfig();
    }

    public void removePlayerFeatureStatus(String playerKey, String featureId) {
        this.featureConfig.set("players." + playerKey + "." + featureId, null);
        if (this.plugin.getConfigManager().getDebugMode()) {
            this.plugin.getLogger().info(String.format("[FeatureConfig] Removing player key '%s', feature '%s'.", playerKey, featureId));
        }
        if (this.featureConfig.contains("players." + playerKey) && this.featureConfig.getConfigurationSection("players." + playerKey).getKeys(false).isEmpty()) {
            this.featureConfig.set("players." + playerKey, null);
            if (this.plugin.getConfigManager().getDebugMode()) {
                this.plugin.getLogger().info(String.format("[FeatureConfig] Player section for key '%s' is empty, removing it.", playerKey));
            }
        }
        this.saveConfig();
    }

    public void clearAllPlayerData() {
        this.featureConfig.set("players", null);
        this.saveConfig();
        this.plugin.getLogger().info("All player data has been cleared from features.yml.");
    }
}

