/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.config;

import ethertaco.sundries.Sundries;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class ConfigManager {
    private final Sundries plugin;
    private File configFile;
    private FileConfiguration config;

    public ConfigManager(Sundries plugin) {
        this.plugin = plugin;
        this.setupConfig();
    }

    private void setupConfig() {
        this.configFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (!this.configFile.exists()) {
            this.plugin.saveResource("config.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    public void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.plugin.getLogger().info("config.yml reloaded.");
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save config.yml: " + e.getMessage());
        }
    }

    public String getConfigVersion() {
        return this.config.getString("config-version", "0.0.0");
    }

    public boolean isPluginEnabled() {
        return this.config.getBoolean("plugin-enabled", true);
    }

    public void setPluginEnabled(boolean enabled) {
        this.config.set("plugin-enabled", (Object)enabled);
        this.saveConfig();
        this.plugin.setPluginRuntimeEnabled(enabled);
    }

    public String getLanguage() {
        return this.config.getString("language", "en_US");
    }

    public void setLanguage(String langCode) {
        this.config.set("language", (Object)langCode);
        this.saveConfig();
    }

    public boolean getDefaultFeatureStatus(String featureId) {
        return this.config.getBoolean("default-features." + featureId, true);
    }

    public void setDefaultFeatureStatus(String featureId, boolean enabled) {
        this.config.set("default-features." + featureId, (Object)enabled);
        this.saveConfig();
    }

    public double getFurnaceSpeed(String dimensionName, String furnaceType) {
        if (this.config.contains("furnace-speeds.dimensions." + dimensionName.toLowerCase() + "." + furnaceType.toUpperCase())) {
            return this.config.getDouble("furnace-speeds.dimensions." + dimensionName.toLowerCase() + "." + furnaceType.toUpperCase());
        }
        return this.config.getDouble("furnace-speeds.global." + furnaceType.toUpperCase(), 100.0);
    }

    public void setFurnaceSpeed(String dimensionName, String furnaceType, double speedPercentage) {
        if (dimensionName.equalsIgnoreCase("global")) {
            this.config.set("furnace-speeds.global." + furnaceType.toUpperCase(), (Object)speedPercentage);
        } else {
            this.config.set("furnace-speeds.dimensions." + dimensionName.toLowerCase() + "." + furnaceType.toUpperCase(), (Object)speedPercentage);
        }
        this.saveConfig();
    }

    public void resetFurnaceSpeed(String dimensionName, String furnaceType) {
        if (dimensionName.equalsIgnoreCase("global")) {
            this.config.set("furnace-speeds.global." + furnaceType.toUpperCase(), null);
        } else {
            this.config.set("furnace-speeds.dimensions." + dimensionName.toLowerCase() + "." + furnaceType.toUpperCase(), null);
            if (this.config.contains("furnace-speeds.dimensions." + dimensionName.toLowerCase()) && Objects.requireNonNull(this.config.getConfigurationSection("furnace-speeds.dimensions." + dimensionName.toLowerCase())).getKeys(false).isEmpty()) {
                this.config.set("furnace-speeds.dimensions." + dimensionName.toLowerCase(), null);
            }
        }
        this.saveConfig();
    }

    public Set<String> getFurnaceSpeedDimensions() {
        if (this.config.contains("furnace-speeds.dimensions")) {
            return Objects.requireNonNull(this.config.getConfigurationSection("furnace-speeds.dimensions")).getKeys(false);
        }
        return new HashSet<String>();
    }

    public Map<String, Double> getFurnaceSpeedsForDimension(String dimensionName) {
        HashMap<String, Double> speeds = new HashMap<String, Double>();
        if (dimensionName.equalsIgnoreCase("global")) {
            return this.getGlobalFurnaceSpeeds();
        }
        if (this.config.contains("furnace-speeds.dimensions." + dimensionName.toLowerCase())) {
            this.config.getConfigurationSection("furnace-speeds.dimensions." + dimensionName.toLowerCase()).getKeys(false).forEach(type -> speeds.put((String)type, this.config.getDouble("furnace-speeds.dimensions." + dimensionName.toLowerCase() + "." + type)));
        }
        return speeds;
    }

    public Map<String, Double> getGlobalFurnaceSpeeds() {
        HashMap<String, Double> speeds = new HashMap<String, Double>();
        if (this.config.contains("furnace-speeds.global")) {
            this.config.getConfigurationSection("furnace-speeds.global").getKeys(false).forEach(type -> speeds.put((String)type, this.config.getDouble("furnace-speeds.global." + type)));
        }
        return speeds;
    }

    public boolean isAllowSurvivalFly() {
        return this.config.getBoolean("allow-survival-fly", false);
    }

    public void setAllowSurvivalFly(boolean allow) {
        this.config.set("allow-survival-fly", (Object)allow);
        this.saveConfig();
        this.plugin.getFlyManager().setAllowFlyInSurvival(allow);
    }

    public boolean getDebugMode() {
        return this.config.getBoolean("debug-mode", false);
    }

    public void setDebugMode(boolean debugMode) {
        this.config.set("debug-mode", (Object)debugMode);
        this.saveConfig();
    }

    public boolean isAfkEnabled() {
        return this.config.getBoolean("afk.enabled", true);
    }

    public int getAfkTimeoutMinutes() {
        return this.config.getInt("afk.timeout-minutes", 5);
    }

    public boolean isAfkSubtitleEnabled() {
        return this.config.getBoolean("afk.subtitle-enabled", true);
    }

    public boolean isAfkAllowMoveToExit() {
        return this.config.getBoolean("afk.allow-move-to-exit", false);
    }

    public boolean isGodModeBypassKill() {
        return this.config.getBoolean("god-mode.bypass-kill-command", true);
    }

    public List<String> getAfkBypassDamageTypes() {
        return this.config.getStringList("afk.bypass-damage-types");
    }

    public String getStorageMode(String module) {
        return this.config.getString("storage-modes." + module, "name");
    }

    public void setStorageMode(String module, String mode) {
        this.config.set("storage-modes." + module, (Object)mode);
    }

    public String getPlayerStorageKey(Player player, String module) {
        String mode = this.getStorageMode(module);
        if (mode.equalsIgnoreCase("uuid")) {
            return player.getUniqueId().toString();
        }
        return player.getName().toLowerCase();
    }

    public String getOfflinePlayerStorageKey(OfflinePlayer player, String module) {
        String mode = this.getStorageMode(module);
        if (mode.equalsIgnoreCase("uuid")) {
            return player.getUniqueId().toString();
        }
        String name = player.getName();
        return name != null ? name.toLowerCase() : player.getUniqueId().toString();
    }

    public boolean useVanillaGamemodePermissions() {
        return this.config.getBoolean("gamemode-settings.use-vanilla-permissions", false);
    }
}

