/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.commands;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.commands.AbstractCommand;
import ethertaco.sundries.modules.afk.AFKCommand;
import ethertaco.sundries.modules.autocrafter.AutoCrafterCommand;
import ethertaco.sundries.modules.core.ConfirmCommand;
import ethertaco.sundries.modules.core.FunctionCommand;
import ethertaco.sundries.modules.core.LangCommand;
import ethertaco.sundries.modules.core.OffCommand;
import ethertaco.sundries.modules.core.OnCommand;
import ethertaco.sundries.modules.core.PermCommand;
import ethertaco.sundries.modules.core.ReloadCommand;
import ethertaco.sundries.modules.core.StatusCommand;
import ethertaco.sundries.modules.core.UpdateConfigCommand;
import ethertaco.sundries.modules.fly.FlyCommand;
import ethertaco.sundries.modules.fly.FlySpeedCommand;
import ethertaco.sundries.modules.furnace.FurnaceCommand;
import ethertaco.sundries.modules.god.GodCommand;
import ethertaco.sundries.modules.mute.CheckMuteCommand;
import ethertaco.sundries.modules.mute.MuteCommand;
import ethertaco.sundries.modules.mute.UnmuteCommand;
import ethertaco.sundries.modules.simplecommand.GameModeCommand;
import ethertaco.sundries.modules.simplecommand.SudoCommand;
import ethertaco.sundries.modules.simplecommand.SuicideCommand;
import ethertaco.sundries.modules.simplegui.AnvilCommand;
import ethertaco.sundries.modules.simplegui.CraftCommand;
import ethertaco.sundries.modules.simplegui.EnderCommand;
import ethertaco.sundries.modules.sit.SitCommand;
import ethertaco.sundries.utils.MessageUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;

public class SundriesCommand
implements TabExecutor {
    private final Sundries plugin;
    private final Map<String, AbstractCommand> subCommands;
    private final Set<String> disabledPluginCommandWhitelist = new HashSet<String>(Arrays.asList("on", "reload", "lang", "updateconfig", "confirm", "help"));

    public SundriesCommand(Sundries plugin) {
        this.plugin = plugin;
        this.subCommands = new HashMap<String, AbstractCommand>();
        this.registerSubCommands();
    }

    private void registerSubCommands() {
        this.subCommands.put("on", new OnCommand(this.plugin));
        this.subCommands.put("off", new OffCommand(this.plugin));
        this.subCommands.put("reload", new ReloadCommand(this.plugin));
        this.subCommands.put("lang", new LangCommand(this.plugin));
        this.subCommands.put("status", new StatusCommand(this.plugin));
        this.subCommands.put("function", new FunctionCommand(this.plugin));
        this.subCommands.put("perm", new PermCommand(this.plugin));
        this.subCommands.put("suicide", new SuicideCommand(this.plugin));
        this.subCommands.put("furnace", new FurnaceCommand(this.plugin));
        this.subCommands.put("sudo", new SudoCommand(this.plugin));
        this.subCommands.put("fly", new FlyCommand(this.plugin));
        this.subCommands.put("flyspeed", new FlySpeedCommand(this.plugin));
        this.subCommands.put("sit", new SitCommand(this.plugin));
        this.subCommands.put("anvil", new AnvilCommand(this.plugin));
        this.subCommands.put("craft", new CraftCommand(this.plugin));
        this.subCommands.put("ender", new EnderCommand(this.plugin));
        this.subCommands.put("afk", new AFKCommand(this.plugin));
        this.subCommands.put("god", new GodCommand(this.plugin));
        this.subCommands.put("updateconfig", new UpdateConfigCommand(this.plugin));
        this.subCommands.put("confirm", new ConfirmCommand(this.plugin));
        this.subCommands.put("mute", new MuteCommand(this.plugin));
        this.subCommands.put("unmute", new UnmuteCommand(this.plugin));
        this.subCommands.put("checkmute", new CheckMuteCommand(this.plugin));
        this.subCommands.put("gm", new GameModeCommand(this.plugin));
        if (this.plugin.getConfigManager().getDefaultFeatureStatus("autocrafter")) {
            this.subCommands.put("autocrafter", new AutoCrafterCommand(this.plugin));
        }
        this.subCommands.put("help", new AbstractCommand(this.plugin, "help", "sundries.command.help"){

            @Override
            public boolean execute(CommandSender sender, String[] args) {
                MessageUtils.sendInfo(sender, "command.status.header", new Object[0]);
                MessageUtils.sendInfo(sender, "command.help.available_commands", new Object[0]);
                SundriesCommand.this.subCommands.values().stream().filter(cmd -> sender.hasPermission(cmd.getPermission())).forEach(cmd -> MessageUtils.sendInfo(sender, "command.help.command_entry", "command_name", cmd.getCommandName()));
                MessageUtils.sendInfo(sender, "command.status.footer", new Object[0]);
                return true;
            }

            @Override
            public List<String> tabComplete(CommandSender sender, String[] args) {
                return null;
            }
        });
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (this.isSundriesMainCommand(label)) {
            if (args.length == 0) {
                this.subCommands.get("help").execute(sender, new String[0]);
                return true;
            }
            String subCommandName = args[0].toLowerCase();
            String[] subCommandArgs = Arrays.copyOfRange(args, 1, args.length);
            if (!(this.plugin.getConfigManager().isPluginEnabled() || subCommandName.equals("off") || this.disabledPluginCommandWhitelist.contains(subCommandName))) {
                MessageUtils.sendError(sender, "plugin.disabled_global", new Object[0]);
                return true;
            }
            if (this.subCommands.containsKey(subCommandName)) {
                AbstractCommand targetCommand = this.subCommands.get(subCommandName);
                return targetCommand.execute(sender, subCommandArgs);
            }
            MessageUtils.sendError(sender, "command.unknown_subcommand", "subcommand", subCommandName);
            return false;
        }
        String directCommandName = label.toLowerCase();
        if (!(this.plugin.getConfigManager().isPluginEnabled() || directCommandName.equals("off") || this.disabledPluginCommandWhitelist.contains(directCommandName))) {
            MessageUtils.sendError(sender, "plugin.disabled_global", new Object[0]);
            return true;
        }
        AbstractCommand directCommand = this.subCommands.get(directCommandName);
        if (directCommand != null) {
            return directCommand.execute(sender, args);
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (this.isSundriesMainCommand(alias)) {
            if (args.length == 1) {
                if (!this.plugin.getConfigManager().isPluginEnabled()) {
                    return this.disabledPluginCommandWhitelist.stream().filter(subCmd -> subCmd.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
                }
                return this.subCommands.keySet().stream().filter(subCmd -> subCmd.startsWith(args[0].toLowerCase())).filter(subCmd -> sender.hasPermission(this.subCommands.get(subCmd).getPermission())).sorted().collect(Collectors.toList());
            }
            String subCommandName = args[0].toLowerCase();
            AbstractCommand subCommand = this.subCommands.get(subCommandName);
            if (subCommand != null) {
                String[] subCommandArgs = Arrays.copyOfRange(args, 1, args.length);
                return subCommand.tabComplete(sender, subCommandArgs);
            }
        } else {
            String directCommandName = alias.toLowerCase();
            AbstractCommand directCommand = this.subCommands.get(directCommandName);
            if (directCommand != null) {
                return directCommand.tabComplete(sender, args);
            }
        }
        return Collections.emptyList();
    }

    private boolean isSundriesMainCommand(String label) {
        return label.equalsIgnoreCase("sundry") || label.equalsIgnoreCase("sundries") || label.equalsIgnoreCase("su") || label.equalsIgnoreCase("sun") || label.equalsIgnoreCase("sd");
    }
}

