/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.commands;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.commands.AbstractCommand;
import ethertaco.sundries.utils.MessageUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class DirectCommandWrapper
implements CommandExecutor,
TabCompleter {
    private final AbstractCommand abstractCommand;
    private final Sundries plugin;
    private static final Set<String> DISABLED_PLUGIN_COMMAND_WHITELIST = new HashSet<String>(Arrays.asList("on", "reload", "lang", "updateconfig", "confirm", "help"));

    public DirectCommandWrapper(AbstractCommand abstractCommand) {
        this.abstractCommand = abstractCommand;
        this.plugin = Sundries.getInstance();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.plugin.getConfigManager().isPluginEnabled() && !DISABLED_PLUGIN_COMMAND_WHITELIST.contains(this.abstractCommand.getCommandName().toLowerCase())) {
            MessageUtils.sendError(sender, "plugin.disabled_global", new Object[0]);
            return true;
        }
        return this.abstractCommand.execute(sender, args);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!this.plugin.getConfigManager().isPluginEnabled() && !DISABLED_PLUGIN_COMMAND_WHITELIST.contains(this.abstractCommand.getCommandName().toLowerCase())) {
            return null;
        }
        return this.abstractCommand.tabComplete(sender, args);
    }
}

