/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries.commands;

import ethertaco.sundries.Sundries;
import ethertaco.sundries.utils.MessageUtils;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class AbstractCommand {
    protected final Sundries plugin;
    protected final String commandName;
    protected final String permission;

    public AbstractCommand(Sundries plugin, String commandName, String permission) {
        this.plugin = plugin;
        this.commandName = commandName;
        this.permission = permission;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getPermission() {
        return this.permission;
    }

    public abstract boolean execute(CommandSender var1, String[] var2);

    public abstract List<String> tabComplete(CommandSender var1, String[] var2);

    protected boolean checkPermission(CommandSender sender) {
        if (!sender.hasPermission(this.permission)) {
            MessageUtils.sendError(sender, "command.no_permission", "permission", this.permission);
            return false;
        }
        return true;
    }

    protected boolean isPlayer(CommandSender sender) {
        if (!(sender instanceof Player)) {
            MessageUtils.sendError(sender, "command.player_only", new Object[0]);
            return false;
        }
        return true;
    }

    protected void sendUsage(CommandSender sender, String usage) {
        MessageUtils.sendUsage(sender, usage);
    }
}

