/*
 * Decompiled with CFR 0.152.
 */
package ethertaco.sundries;

import ethertaco.sundries.commands.AbstractCommand;
import ethertaco.sundries.commands.DirectCommandWrapper;
import ethertaco.sundries.commands.SundriesCommand;
import ethertaco.sundries.config.ConfigManager;
import ethertaco.sundries.config.FeatureConfig;
import ethertaco.sundries.managers.FeatureToggleManager;
import ethertaco.sundries.managers.LangManager;
import ethertaco.sundries.modules.afk.AFKCommand;
import ethertaco.sundries.modules.afk.AFKListener;
import ethertaco.sundries.modules.afk.AFKManager;
import ethertaco.sundries.modules.autocrafter.AutoCrafterConfig;
import ethertaco.sundries.modules.autocrafter.AutoCrafterListener;
import ethertaco.sundries.modules.autocrafter.AutoCrafterManager;
import ethertaco.sundries.modules.fly.FlyCommand;
import ethertaco.sundries.modules.fly.FlyConfig;
import ethertaco.sundries.modules.fly.FlyListener;
import ethertaco.sundries.modules.fly.FlyManager;
import ethertaco.sundries.modules.fly.FlySpeedCommand;
import ethertaco.sundries.modules.furnace.FurnaceCommand;
import ethertaco.sundries.modules.furnace.FurnaceListener;
import ethertaco.sundries.modules.furnace.FurnaceSpeedManager;
import ethertaco.sundries.modules.god.GodCommand;
import ethertaco.sundries.modules.god.GodConfig;
import ethertaco.sundries.modules.god.GodListener;
import ethertaco.sundries.modules.god.GodManager;
import ethertaco.sundries.modules.mute.CheckMuteCommand;
import ethertaco.sundries.modules.mute.MuteCommand;
import ethertaco.sundries.modules.mute.MuteConfig;
import ethertaco.sundries.modules.mute.MuteListener;
import ethertaco.sundries.modules.mute.MuteManager;
import ethertaco.sundries.modules.mute.UnmuteCommand;
import ethertaco.sundries.modules.simplecommand.GameModeCommand;
import ethertaco.sundries.modules.simplecommand.SudoCommand;
import ethertaco.sundries.modules.simplecommand.SuicideCommand;
import ethertaco.sundries.modules.simplegui.AnvilCommand;
import ethertaco.sundries.modules.simplegui.CraftCommand;
import ethertaco.sundries.modules.simplegui.EnderCommand;
import ethertaco.sundries.modules.sit.SitCommand;
import ethertaco.sundries.modules.sit.SitListener;
import ethertaco.sundries.modules.sit.SitManager;
import ethertaco.sundries.utils.ConfigUpdater;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Sundries
extends JavaPlugin {
    private static Sundries instance;
    private ConfigManager configManager;
    private FeatureConfig featureConfig;
    private FlyConfig flyConfig;
    private GodConfig godConfig;
    private AutoCrafterConfig autoCrafterConfig;
    private MuteConfig muteConfig;
    private AutoCrafterManager autoCrafterManager;
    private FeatureToggleManager featureToggleManager;
    private FurnaceSpeedManager furnaceSpeedManager;
    private LangManager langManager;
    private FlyManager flyManager;
    private SitManager sitManager;
    private AFKManager afkManager;
    private GodManager godManager;
    private MuteManager muteManager;
    private FurnaceListener furnaceListener;
    private FlyListener flyListener;
    private SitListener sitListener;
    private GodListener godListener;
    private AFKListener afkListener;
    private AutoCrafterListener autoCrafterListener;
    private MuteListener muteListener;
    private final Map<UUID, Consumer<CommandSender>> confirmations = new HashMap<UUID, Consumer<CommandSender>>();

    public static Sundries getInstance() {
        return instance;
    }

    public void onEnable() {
        this.getLogger().info("Sundries plugin is enabling...");
        instance = this;
        this.configManager = new ConfigManager(this);
        this.featureConfig = new FeatureConfig(this);
        this.autoCrafterConfig = new AutoCrafterConfig(this);
        this.flyConfig = new FlyConfig(this);
        this.godConfig = new GodConfig(this);
        this.muteConfig = new MuteConfig(this);
        this.langManager = new LangManager(this);
        this.featureToggleManager = new FeatureToggleManager(this, this.configManager, this.featureConfig);
        this.furnaceSpeedManager = new FurnaceSpeedManager(this.configManager);
        this.flyManager = new FlyManager(this, this.flyConfig);
        this.sitManager = new SitManager(this);
        this.godManager = new GodManager(this, this.godConfig);
        this.afkManager = new AFKManager(this, this.configManager);
        this.muteManager = new MuteManager(this, this.muteConfig);
        this.autoCrafterManager = new AutoCrafterManager(this, this.autoCrafterConfig);
        this.checkConfigVersion();
        this.langManager.loadLocale(this.configManager.getLanguage());
        SundriesCommand sundriesCommand = new SundriesCommand(this);
        this.getCommand("sundry").setExecutor((CommandExecutor)sundriesCommand);
        this.getCommand("sundry").setTabCompleter((TabCompleter)sundriesCommand);
        this.registerDirectCommand("suicide", new SuicideCommand(this));
        this.registerDirectCommand("fly", new FlyCommand(this));
        this.registerDirectCommand("furnace", new FurnaceCommand(this));
        this.registerDirectCommand("flyspeed", new FlySpeedCommand(this));
        this.registerDirectCommand("sudo", new SudoCommand(this));
        this.registerDirectCommand("sit", new SitCommand(this));
        this.registerDirectCommand("anvil", new AnvilCommand(this));
        this.registerDirectCommand("craft", new CraftCommand(this));
        this.registerDirectCommand("ender", new EnderCommand(this));
        this.registerDirectCommand("afk", new AFKCommand(this));
        this.registerDirectCommand("god", new GodCommand(this));
        this.registerDirectCommand("mute", new MuteCommand(this));
        this.registerDirectCommand("unmute", new UnmuteCommand(this));
        this.registerDirectCommand("checkmute", new CheckMuteCommand(this));
        this.registerDirectCommand("gm", new GameModeCommand(this));
        this.furnaceListener = new FurnaceListener(this);
        this.flyListener = new FlyListener(this);
        this.sitListener = new SitListener(this);
        this.godListener = new GodListener(this);
        this.afkListener = new AFKListener(this);
        this.autoCrafterListener = new AutoCrafterListener(this);
        this.muteListener = new MuteListener(this);
        this.registerListeners(this.configManager.isPluginEnabled());
        this.autoCrafterManager.validatePlacedAutoCrafters();
        if (!this.configManager.isPluginEnabled()) {
            this.getLogger().warning("Plugin is currently disabled in config.yml. Enable it with /su on.");
        }
        this.getLogger().info("Sundries plugin has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("Sundries plugin is disabling...");
        this.configManager.saveConfig();
        this.featureConfig.saveConfig();
        this.flyConfig.saveConfig();
        this.godConfig.saveConfig();
        this.autoCrafterConfig.saveConfig();
        this.muteConfig.saveConfig();
        this.unregisterListeners();
        this.sitManager.cleanupSeats();
        this.afkManager.cleanup();
        this.muteManager.cleanup();
        this.autoCrafterManager.cleanup();
        this.getLogger().info("Sundries plugin has been disabled!");
    }

    private void registerDirectCommand(String commandName, AbstractCommand commandInstance) {
        if (this.getCommand(commandName) != null) {
            this.getCommand(commandName).setExecutor((CommandExecutor)new DirectCommandWrapper(commandInstance));
            this.getCommand(commandName).setTabCompleter((TabCompleter)new DirectCommandWrapper(commandInstance));
        }
    }

    private void checkConfigVersion() {
        try {
            boolean updated = new ConfigUpdater(this).update();
            if (updated) {
                this.reloadPluginLogic();
            }
        }
        catch (Exception e) {
            this.getLogger().severe("An error occurred while updating configurations: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void reloadPluginLogic() {
        this.configManager.reloadConfig();
        this.featureConfig.reloadConfig();
        this.flyConfig.reloadConfig();
        this.godConfig.reloadConfig();
        this.autoCrafterConfig.reloadConfig();
        this.muteConfig.reloadConfig();
        this.langManager.loadLocale(this.configManager.getLanguage());
        this.flyManager.setAllowFlyInSurvival(this.configManager.isAllowSurvivalFly());
        if (this.afkListener != null) {
            this.afkListener.loadBypassDamageTypes();
        }
        if (this.autoCrafterManager != null) {
            this.autoCrafterManager.validatePlacedAutoCrafters();
        }
        this.getServer().getOnlinePlayers().forEach(player -> {
            this.godManager.loadPlayer((Player)player);
            this.muteManager.loadPlayerMutes((Player)player);
        });
        this.getLogger().info("All configurations and dependent services have been reloaded.");
    }

    private void registerListeners(boolean enable) {
        HandlerList.unregisterAll((Plugin)this);
        if (enable) {
            this.getServer().getPluginManager().registerEvents((Listener)this.furnaceListener, (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)this.flyListener, (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)this.sitListener, (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)this.godListener, (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)this.afkListener, (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)this.autoCrafterListener, (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)this.muteListener, (Plugin)this);
            this.getLogger().info("Listeners registered.");
        } else {
            this.getLogger().info("Listeners not registered because plugin is disabled.");
        }
    }

    private void unregisterListeners() {
        HandlerList.unregisterAll((Plugin)this);
        this.getLogger().info("All listeners unregistered.");
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public FeatureConfig getFeatureConfig() {
        return this.featureConfig;
    }

    public FlyConfig getFlyConfig() {
        return this.flyConfig;
    }

    public GodConfig getGodConfig() {
        return this.godConfig;
    }

    public AutoCrafterConfig getAutoCrafterConfig() {
        return this.autoCrafterConfig;
    }

    public MuteConfig getMuteConfig() {
        return this.muteConfig;
    }

    public FeatureToggleManager getFeatureToggleManager() {
        return this.featureToggleManager;
    }

    public FurnaceSpeedManager getFurnaceSpeedManager() {
        return this.furnaceSpeedManager;
    }

    public LangManager getLangManager() {
        return this.langManager;
    }

    public FlyManager getFlyManager() {
        return this.flyManager;
    }

    public SitManager getSitManager() {
        return this.sitManager;
    }

    public AFKManager getAFKManager() {
        return this.afkManager;
    }

    public GodManager getGodManager() {
        return this.godManager;
    }

    public MuteManager getMuteManager() {
        return this.muteManager;
    }

    public AutoCrafterManager getAutoCrafterManager() {
        return this.autoCrafterManager;
    }

    public Map<UUID, Consumer<CommandSender>> getConfirmations() {
        return this.confirmations;
    }

    public void setPluginRuntimeEnabled(boolean enabled) {
        this.registerListeners(enabled);
    }
}

